% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg4way.R
\name{gg4way}
\alias{gg4way}
\alias{gg4way.default}
\alias{gg4way.MArrayLM}
\alias{gg4way.list}
\alias{gg4way.DESeqDataSet}
\alias{gg4way.SimpleList}
\title{Create a 4way plot}
\usage{
\method{gg4way}{default}(
  DGEdata,
  x = NULL,
  y = NULL,
  ID = "ID",
  symbol = "symbol",
  logFC = "logFC",
  FDR = "adj.P.Val",
  sep = " vs ",
  FDRcutoff = 0.05,
  logFCcutoff = 1,
  label = FALSE,
  textSize = 11,
  textNudge = 0.25,
  labelSize = textSize,
  colorVector = c("grey80", "firebrick", "forestgreen", "mediumblue"),
  lineColor = "grey60",
  ...
)
}
\arguments{
\item{DGEdata}{The object to plot from:
\itemize{
\item \code{limma:} A \link[limma:MArrayLM-class]{MArrayLM} object from
\link[limma]{eBayes} or \link[limma]{treat}
\item \code{edgeR:} A list of \link[edgeR:DGELRT-class]{DGELRT} objects
from \link[edgeR]{glmQLFTest}, \link[edgeR]{glmTreat},
or \link[edgeR]{glmLRT}
\item \code{DESeq2:} a \link[DESeq2:DESeqDataSet-class]{DESeqDataSet} from
\link[DESeq2]{DESeq} or a list of
\link[DESeq2:DESeqResults-class]{DESeqResults} from \link[DESeq2]{results}
\item \code{Other packages:} A list of data.frames,
see details section for more information
}}

\item{x}{Character specifying the name of DGE results within the object
for the x-axis}

\item{y}{Character specifying the name of DGE results within the object
for the y-axis}

\item{ID}{Column name for gene IDs}

\item{symbol}{Column name for gene symbols, which can be the same as the
value for the ID column if not present in the object}

\item{logFC}{Column name for logFC values}

\item{FDR}{Column name for FDR values}

\item{sep}{Character specifying the separator between conditions
for the contrast name provided to the x and y arguments}

\item{FDRcutoff}{Numeric for the FDR cut-off for DEGs (default is 0.05)}

\item{logFCcutoff}{Numeric for the absolute logFC cut-off for DEGs
(default is 1)}

\item{label}{Character vector specifying the symbols of genes to label
(FALSE for none, TRUE for all blue)}

\item{textSize}{Numeric specifying size of text with gene
overlap category totals, where 0 will remove the text}

\item{textNudge}{Numeric specifying nudge of text with gene
overlap category totals}

\item{labelSize}{Numeric specifying size of text with gene labels}

\item{colorVector}{Character vector of colors in the following order:
"not significant", "significant in x", "significant in y",
"significant in both"}

\item{lineColor}{Color of lines}

\item{...}{Support for additional arguments used internally by
\code{gg4way.MArrayLM}, \code{gg4way.list},
and \code{gg4way.DESeqDataSet}}
}
\value{
A \link[ggplot2]{ggplot}
}
\description{
Create a 4way plot to compare the logFC values from
two contrasts of differential gene expression.
}
\details{
When a named list of data.frames is provided to the \code{DGEdata} argument,
each data.frame can follow the defaults and have the following columns or
specify alternate names for the following to the ID, symbol, logFC, and FDR
arguments:
\tabular{ll}{
\code{ID} \tab Character vector with the feature ID (i.e. EnsemblID) \cr
\tab \cr
\code{symbol} \tab Optional character vector with gene symbol for labels \cr
\tab \cr
\code{logFC} \tab Numeric with the logFC \cr
\tab \cr
\code{adj.P.Val} \tab Numeric with the FDR \cr
}
The correlation coefficient is useful for comparing across multiple plots.
However, it is important to consider whether there are any common factors
when comparing values, since that can result in a larger value. Some
examples are contrasts with covariates that are shared between groups
or contrasts with the same control group.
}
\examples{
data("airwayFit")
airwayFit |>
    gg4way(x = "N61311 vs N052611",
           y = "N061011 vs N052611")
}
