% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gep2pep.R
\name{loadPVmatrix}
\alias{loadPVmatrix}
\title{Loads the matrix of p-values for a collection}
\usage{
loadPVmatrix(rp, collection)
}
\arguments{
\item{rp}{A repository created by \code{\link{createRepository}}.}

\item{collection}{One of the names returned by
\code{getCollections}.}
}
\value{
The matrix of p-values (PV) of the
    Kolmogorov-Smirnov statistic for the pathway collection, if
    previously computed with \code{buildPEPs}. The entry \code{i,j}
    reports the PV for the pathway \code{i}, condition{j}. If
    \code{buildPEPs} was not run, throws an error.
}
\description{
Loads the matrix of p-values for a collection
}
\examples{

db <- loadSamplePWS()
repo_path <- file.path(tempdir(), "gep2pepTemp")

rp <- createRepository(repo_path, db)
geps <- loadSampleGEP()
buildPEPs(rp, geps)

loadPVmatrix(rp, "c3_TFT")

unlink(repo_path, TRUE)

}
