% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gep2pep.R
\name{getCollections}
\alias{getCollections}
\title{Returns the names of the pathway collections in a repository.}
\usage{
getCollections(rp)
}
\arguments{
\item{rp}{A repository created by \code{\link{createRepository}}.}
}
\value{
Vector of collection names (see details).
}
\description{
Given a \code{gep2pep} repository, returns the names of the
stored collections by looking at appropriate repository item
names.
}
\details{
Each collection in a database has a "category" and a
    "subcategory" assigned, which are used to build the collection
    identifier as "category_subcategory". This function obtains the
    identifiers by looking at data stored in the repository
    \code{rp} (entries that are tagged with "sets").
}
\examples{

db <- loadSamplePWS()
repo_path <- file.path(tempdir(), "gep2pepTemp")

rp <- createRepository(repo_path, db)
## Repo root created.
## Repo created.
## [15:45:06] Storing pathway data for collection: c3_TFT
## [15:45:06] Storing pathway data for collection: c3_MIR
## [15:45:06] Storing pathway data for collection: c4_CGN

getCollections(rp)
## [1] "c3_TFT" "c3_MIR" "c4_CGN"

unlink(repo_path, TRUE)

}
