% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/threeJsViewer.R
\name{threeJsViewer}
\alias{threeJsViewer}
\title{threeJs Viewer
The htmlwidgets viewer for threeJs.}
\usage{
threeJsViewer(
  ...,
  background = c("#33333388", "#444444DD", "#444444DD", "#33333388"),
  maxRadius = 1,
  maxLineWidth = 50,
  title = NULL,
  width = NULL,
  height = NULL
)
}
\arguments{
\item{...}{objects of threeJsGeometry.}

\item{background}{background of the main camera (left and right).}

\item{maxRadius}{max value of the controls for radius.}

\item{maxLineWidth}{max value of the controls for line width.}

\item{title}{the titles of the plot.}

\item{width, height}{width and height of the widgets.}
}
\value{
A htmlwidgets widget.
}
\description{
threeJs Viewer
The htmlwidgets viewer for threeJs.
}
\details{
We convert data frames to JSON by getOption("shiny.json.digits", 7)
to avoid the error 
"Uncaught SyntaxError: Expected ',' or ']' after array element in JSON"
for json parse process when handling big data. User can change the
option 'shiny.json.digits' larger or smaller number to increase or decrease
the digits when converting numbers.
}
\examples{
library(GenomicRanges)
flamingo <- system.file("extdata", "4DNFI1UEG1HD.chr21.FLAMINGO.res.rds", package = "geomeTriD")
x <- readRDS(flamingo[[1]])
## resize to bigger value to get better init view
mcols(x) <- as.data.frame(mcols(x)) * 1e5
set.seed(1)
line <- threeJsGeometry(
  x = x$x, y = x$y, z = x$z,
  colors = sample(palette(), length(x), replace = TRUE),
  type = "line",
  properties = list(size = 4)
)
sphere <- x[sample.int(length(x), 100)]
sphere <- threeJsGeometry(
  x = sphere$x, y = sphere$y, z = sphere$z,
  colors = "red",
  type = "sphere",
  properties = list(radius = 0.08)
)
torus <- x[sample.int(length(x), 100)]
torus <- threeJsGeometry(
  x = torus$x, y = torus$y, z = torus$z,
  colors = "blue",
  type = "torus",
  properties = list(
    radius = 0.08,
    tube = 0.03
  )
)
cylinder <- x[sample.int(length(x), 100)]
cylinder <- threeJsGeometry(
  x = cylinder$x, y = cylinder$y, z = cylinder$z,
  colors = "green",
  type = "cylinder",
  properties = list(
    "height" = 0.07,
    "radiusTop" = 0.05,
    "radiusBottom" = 0.09
  )
)
labels <- x[sample.int(length(x), 5)]
fontURL <- paste0('https://raw.githubusercontent.com/mrdoob/three.js/refs/',
   'heads/dev/examples/fonts/helvetiker_regular.typeface.json')
labels <- threeJsGeometry(
  x = labels$x, y = labels$y, z = labels$z,
  colors = "black",
  type = "text",
  properties = list(
    "label" = "text",
    "font" = readLines(fontURL),
    "size" = .5,
    "depth" = .1
  )
)
threeJsViewer(line, sphere, torus, cylinder)
}
