% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create3dGenomicSignals.R
\name{create3dGenomicSignals}
\alias{create3dGenomicSignals}
\title{create 3d Geometry by given genomic signals}
\usage{
create3dGenomicSignals(
  GenoSig,
  targetObj,
  signalTransformFun,
  positionTransformFun,
  genomicScoreRange,
  reverseGenomicSigs,
  type = "segment",
  tag,
  name,
  color = c("gray30", "darkred"),
  rotation = c(0, 0, 0),
  ...
)
}
\arguments{
\item{GenoSig}{The Genomic signals. An object of
\link[GenomicRanges:GRanges-class]{GRanges}, 
\link[S4Vectors:Pairs-class]{Pairs},
or \link[InteractionSet]{GInteractions} with scores or
 an object of \link[trackViewer:track]{track}.}

\item{targetObj}{The GRanges object with mcols x0, y0, z0, x1, y1, and z1}

\item{signalTransformFun}{The transformation function for genomic signals.}

\item{positionTransformFun}{The transformation function for the coordinates.
The function must have input as a data.frame with colnames
 x0, y0, z0, x1, y1, and z1. And it must have
output as same dimension data.frame.}

\item{genomicScoreRange}{The genomic signals range.}

\item{reverseGenomicSigs}{Plot the genomic signals in reverse values.}

\item{type}{The Geometry type.See \link{threeJsGeometry}}

\item{tag}{The tag used to group geometries.}

\item{name}{The prefix for the name of the geometries.}

\item{color}{The color of the signal. If there is metadata 'color' in GenoSig
this parameter will be ignored.}

\item{rotation}{The rotations in the x, y and 
z axis in radians.}

\item{...}{the parameters for each different type of geometries.
If type is 'segments', lwd.maxGenomicSigs (the maximal lwd of the line) is
 required.
If type is 'circle', radius (the radius of the circle) and
 the maxVal (the value for 2*pi) is
 required.
If type is 'sphere', 'dodecahedron', 'icosahedron', 'octahedron',
or 'tetrahedron', radius is
 required.
If type is 'box', 'capsule', 'cylinder', 'cone', or 'torus', if
the properties of correspond geometry is not set, they will be set to
the transformed score value.
If type is 'json', please refer the documentation about
BufferGeometryLoader at threejs.org
If input 'GenoSig' is an object of Pairs or GInteractions, the type will be
set to 'polygon' and topN is used to set how many top events will be plot.}
}
\value{
\link{threeJsGeometry} objects or NULL
}
\description{
Create a 3d Geometry by given genomic signals for target 3d positions.
}
\examples{
library(GenomicRanges)
GenoSig <- GRanges("chr1", IRanges(seq(1, 100, by = 10), width = 10),
  score = seq.int(10)
)
pos <- matrix(rnorm(303), ncol = 3)
pos <- cbind(
  x0 = pos[seq.int(100), 1],
  x1 = pos[seq.int(101)[-1], 1],
  y0 = pos[seq.int(100), 2],
  y1 = pos[seq.int(101)[-1], 2],
  z0 = pos[seq.int(100), 3],
  z1 = pos[seq.int(101)[-1], 3]
)
targetObj <- GRanges("chr1", IRanges(seq.int(100), width = 1))
mcols(targetObj) <- pos
ds <- create3dGenomicSignals(GenoSig, targetObj,
  signalTransformFun = function(x) {
    log2(x + 1)
  },
  reverseGenomicSigs = FALSE,
  type = "segment",
  lwd.maxGenomicSigs = 8,
  name = "test",
  tag = "test"
)
threeJsViewer(ds)
}
