% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/view3dStructure.R
\name{view3dStructure}
\alias{view3dStructure}
\title{Plot GRanges xyz data in 2d or 3d}
\usage{
view3dStructure(
  obj,
  feature.gr,
  genomicSigs,
  region,
  signalTransformFun = function(x) {
     log2(x + 1)
 },
  k = 3,
  renderer = c("rgl", "threejs", "none"),
  lwd.backbone = 2,
  col.backbone = "gray",
  lwd.maxGenomicSigs = 8,
  reverseGenomicSigs = TRUE,
  col.backbone_background = if (k == 2) "gray70" else c("gray30", "darkred"),
  alpha.backbone_background = 0.5,
  lwd.gene = 3,
  coor_mark_interval = 5e+05,
  col.coor = "black",
  show_coor = TRUE,
  coor_tick_unit = 50000,
  label_gene = TRUE,
  col.tension_line = "black",
  lwd.tension_line = 1,
  length.arrow = unit(abs(diff(obj$x))/20, "native"),
  safe_text_force = 3,
  square = TRUE,
  cluster3Dpoints = FALSE,
  ...
)
}
\arguments{
\item{obj}{GRanges object with mcols x, y, and/or z}

\item{feature.gr}{The annotation features to be added. An object of \link[GenomicRanges:GRanges-class]{GRanges}.}

\item{genomicSigs}{The Genomic signals. An object of \link[GenomicRanges:GRanges-class]{GRanges} with scores or an object of \link[trackViewer:track]{track}.}

\item{region}{A GRanges object with the region to be plot.}

\item{signalTransformFun}{The transformation function for genomic signals.}

\item{k}{The dimension of plot. 2: 2d, 3: 3d.}

\item{renderer}{The renderer of the 3D plots. Could be rgl or threejs.
The threejs will create a htmlwidgets. If 'none' is set, a list of object
will be returned.}

\item{lwd.backbone, lwd.gene, lwd.tension_line, lwd.maxGenomicSigs}{Line width for the
linker, gene, interaction node circle, the dashed line of interaction edges, the tension line and the maximal reversed genomic signal.}

\item{col.backbone, col.backbone_background, col.tension_line, col.coor}{Color
for the DNA chain, the compact DNA chain, the node circle, the linker, the tension line and the coordinates marker.}

\item{reverseGenomicSigs}{Plot the genomic signals in reverse values.}

\item{alpha.backbone_background}{Alpha channel for transparency of backbone background.}

\item{coor_mark_interval}{The coordinates marker interval. Numeric(1). Set to 0
to turn it off. The default value 1e5 means show coordinates every 0.1M bp.}

\item{show_coor}{Plot ticks in the line to show the DNA compact tension.}

\item{coor_tick_unit}{The bps for every ticks. Default is 1K.}

\item{label_gene}{Show gene symbol or not.}

\item{length.arrow}{Length of the edges of the arrow head (in inches).}

\item{safe_text_force}{The loops to avoid the text overlapping.}

\item{square}{A logical value that controls whether control points for the curve are created city-block fashion or obliquely. See \link[grid]{grid.curve}.}

\item{cluster3Dpoints}{A logical value that controls whether cluster the points
in 3D. It will be ignored when k=2.}

\item{...}{Parameters for \link{create3dGenomicSignals}.}
}
\value{
Coordinates for 2d or a list of threeJsGeometry objects or a
htmlwidget.
}
\description{
Plot GRanges xyz data with grid or rgl package.
}
\examples{
obj <- readRDS(system.file("extdata", "4DNFI1UEG1HD.chr21.FLAMINGO.res.rds",
  package = "geomeTriD"
))
feature.gr <- readRDS(system.file("extdata", "4DNFI1UEG1HD.feature.gr.rds",
  package = "geomeTriD"
))
tjg <- view3dStructure(obj,
  k = 3, feature.gr = feature.gr, renderer = "none",
  length.arrow = grid::unit(0.000006, "native")
)
}
