% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scoreMatrix.R, R/scoreMatrixList.R
\docType{methods}
\name{binMatrix}
\alias{binMatrix}
\alias{binMatrix,ScoreMatrix-method}
\alias{binMatrix,ScoreMatrixList-method}
\title{Bins the columns of a matrix using a user provided function}
\usage{
binMatrix(x, bin.num = NULL, fun = "mean")

\S4method{binMatrix}{ScoreMatrix}(x, bin.num = NULL, fun = "mean")

\S4method{binMatrix}{ScoreMatrixList}(x, bin.num = NULL, fun = "mean")
}
\arguments{
\item{x}{\code{ScoreMatrix} or a \code{ScoreMatrixList} object}

\item{bin.num}{\code{integer} number of bins in the final matrix}

\item{fun}{\code{character} vector or an anonymous function that will be used for binning}
}
\value{
\code{ScoreMatrix} or \code{ScoreMatrixList} object
}
\description{
Bins the columns of a matrix using a user provided function
}
\examples{

# binning the columns in a ScoreMatrix object
library(GenomicRanges)
target = GRanges(rep(c(1,2),each=7), IRanges(rep(c(1,1,2,3,7,8,9), times=2), width=5), 
weight = rep(c(1,2),each=7), 
strand=c('-', '-', '-', '-', '+', '-', '+', '-', '-', '-', '-', '-', '-', '+'))
windows = GRanges(rep(c(1,2),each=2), IRanges(rep(c(1,2), times=2), width=5), 
strand=c('-','+','-','+'))
sm = ScoreMatrix(target, windows)
bin = binMatrix(sm, bin.num=2)

}
