% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/st.gallen.R
\name{st.gallen}
\alias{st.gallen}
\title{Function to compute the St Gallen consensus criterion for
prognostication}
\usage{
st.gallen(size, grade, node, her2.neu, age, vascular.inv, na.rm = FALSE)
}
\arguments{
\item{size}{tumor size in cm.}

\item{grade}{Histological grade, i.e. low (1), intermediate (2) and
high (3) grade.}

\item{node}{Nodal status (0 or 1 for no lymph node invasion a,d at
least 1 invaded lymph ode respectively).}

\item{her2.neu}{Her2/neu status (0 or 1).}

\item{age}{Age at diagnosis (in years).}

\item{vascular.inv}{Peritumoral vascular invasion (0 or 1).}

\item{na.rm}{TRUE if missing values should be removed, FALSE otherwise.}
}
\value{
Vector of risk predictions: "Good", "Intermediate", and "Poor".
}
\description{
This function computes the updated St Gallen consensus criterions as
published by Goldhirsh et al 2003.
}
\examples{
# load nkis dataset
data(nkis)

# compute St Gallen predictions
st.gallen(size=demo.nkis[ ,"size"], grade=demo.nkis[ ,"grade"],
  node=demo.nkis[ ,"node"], her2.neu=sample(x=0:1, size=nrow(demo.nkis),
  replace=TRUE), age=demo.nkis[ ,"age"], vascular.inv=sample(x=0:1,                                                                                                           
  size=nrow(demo.nkis), replace=TRUE), na.rm=TRUE)

}
\references{
Goldhirsh A, Wood WC, Gelber RD, Coates AS, Thurlimann B, and Senn HJ
(2003) "Meeting highlights: Updated international expert
consensus on the primary therapy of early breast cancer", Journal of
Clinical Oncology, 21(17):3357-3365.
}
\seealso{
\link{npi}
}
