% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rescale.R
\name{rescale}
\alias{rescale}
\title{Function to rescale values based on quantiles}
\usage{
rescale(x, na.rm = FALSE, q = 0)
}
\arguments{
\item{x}{The \code{matrix} or \code{vector} to rescale.}

\item{na.rm}{TRUE if missing values should be removed, FALSE otherwise.}

\item{q}{Quantile (must lie in [0,1]]).}
}
\value{
A vector of rescaled values with two attributes q1 and q1 containing
the values of the lower and the upper quantiles respectively.
}
\description{
This function rescales values x based on quantiles specified by the user
such that x' = (x - q1) / (q2 - q1) where q is the specified quantile,
q1 = q / 2, q2 = 1 - q/2) and x' are the new rescaled values.
}
\details{
In order to rescale gene expressions, q = 0.05 yielded comparable scales in
numerous breast cancer microarray datasets (data not shown).The rational
behind this is that, in general, 'extreme cases' (e.g. low and high
proliferation, high and low expression of ESR1, ...) are often present
in microarray datasets, making the estimation of 'extreme' quantiles
quite stable. This is specially true for genes exhibiting some
multi-modality like ESR1 or ERBB2.
}
\examples{
# load VDX dataset
data(vdxs)
# load NKI dataset
data(nkis)
# example of rescaling for ESR1 expression
par(mfrow=c(2,2))
hist(data.vdxs[ ,"205225_at"], xlab="205225_at", breaks=20,
  main="ESR1 in VDX")
hist(data.nkis[ ,"NM_000125"], xlab="NM_000125", breaks=20,
  main="ESR1 in NKI")
hist((rescale(x=data.vdxs[ ,"205225_at"], q=0.05) - 0.5) * 2,
  xlab="205225_at", breaks=20, main="ESR1 in VDX\nrescaled")
hist((rescale(x=data.nkis[ ,"NM_000125"], q=0.05) - 0.5) * 2,
  xlab="NM_000125", breaks=20, main="ESR1 in NKI\nrescaled")

}
\seealso{
\code{\link[base:scale]{base::scale()}}
}
