% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ovcTCGA.R
\name{ovcTCGA}
\alias{ovcTCGA}
\title{Function to compute the prediction scores and risk classifications
for the ovarian cancer TCGA signature}
\usage{
ovcTCGA(data, annot,
  gmap = c("entrezgene", "ensembl_gene_id", "hgnc_symbol", "unigene"),
  do.mapping = FALSE, verbose = FALSE)
}
\arguments{
\item{data}{Matrix of gene expressions with samples in rows and probes in
columns, dimnames being properly defined.}

\item{annot}{Matrix of annotations with one column named as gmap, dimnames
being properly defined.}

\item{gmap}{character string containing the biomaRt attribute to use for
mapping if do.mapping=TRUE}

\item{do.mapping}{TRUE if the mapping through Entrez Gene ids must be
performed (in case of ambiguities, the most variant probe is kept for
each gene), FALSE otherwise.}

\item{verbose}{TRUE to print informative messages, FALSE otherwise.}
}
\value{
A list with items:
\itemize{
\item score:	Continuous signature scores.
\item risk: Binary risk classification, 1 being high risk and 0 being low risk.
\item mapping: Mapping used if necessary.
\item probe:	If mapping is performed, this matrix contains the correspondence
between the gene list (aka signature) and gene expression data.
}
}
\description{
This function computes signature scores and risk classifications from gene
expression values following the algorithm developed by the TCGA consortium
for ovarian cancer.
}
\examples{
# load the ovcTCGA signature
data(sigOvcTCGA)
# load NKI dataset
data(nkis)
colnames(annot.nkis)[is.element(colnames(annot.nkis), "EntrezGene.ID")] <- "entrezgene"
# compute relapse score
ovcTCGA.nkis <- ovcTCGA(data=data.nkis, annot=annot.nkis, gmap="entrezgene", do.mapping=TRUE)
table(ovcTCGA.nkis$risk)

}
\references{
Bell D, Berchuck A, Birrer M et al. (2011) "Integrated genomic analyses of
ovarian carcinoma", Nature, 474(7353):609-615
}
\seealso{
\link{sigOvcTCGA}
}
