% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/barChart.r
\name{barChart}
\alias{barChart}
\title{Produces bar charts.}
\usage{
barChart(organism, start, end, by)
}
\arguments{
\item{organism}{Object name assigned from readGFF() command.}

\item{start}{Lower bound of upstream extension.}

\item{end}{Upper bound of upstream extension.}

\item{by}{Interval between consecutive extensions.}
}
\value{
Creates bar charts.
}
\description{
Makes bar graphs showing the number of genes under peaks at various upstream extension levels.
}
\examples{
library(rtracklayer)
rat <- readGFF("ftp://ftp.ensembl.org/pub/release-84/gtf/rattus_norvegicus/Rattus_norvegicus.Rnor_6.0.84.gtf.gz")
fpath <- system.file("extdata", "somepeaksfile.txt", package="geneXtendeR")
peaksInput(fpath)
barChart(rat, 1000, 3000, 100)

}
