% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allGenericFunctions.R,
%   R/Class_FixedExpressionData.R
\docType{methods}
\name{getTargetValue}
\alias{getTargetValue}
\alias{getTargetValue,FixedExpressionData-method}
\title{Obtain the targetValue}
\usage{
getTargetValue(object)

\S4method{getTargetValue}{FixedExpressionData}(object)
}
\arguments{
\item{object}{An object of class \code{\link{FixedExpressionData}}}
}
\value{
A numeric value
}
\description{
\code{getTargetValue} returns the current applied targetValue
in the MAS5.0 gene expression data.
}
\examples{
data(exampleMAS5)
myData <- setNormalizationMethod(exampleMAS5, "MAS5.0", targetValue=500)
getTargetValue( myData )
}
\seealso{
Other fixed data information extraction functions: \code{\link{[,FixedExpressionData,ANY,ANY-method}},
  \code{\link{dim,FixedExpressionData-method}},
  \code{\link{getNormalizationMethod}}
}
\concept{fixed data information extraction functions}
