% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allGenericFunctions.R,
%   R/Class_ClassifierParameters.R
\docType{methods}
\name{getMeans}
\alias{getMeans}
\alias{getMeans,ClassifierParameters-method}
\title{Obtain classifiers' reference means.}
\usage{
getMeans(object)

\S4method{getMeans}{ClassifierParameters}(object)
}
\arguments{
\item{object}{An object of class \code{\link{ClassifierParameters}}
as returned by \code{\link{getClassifier}}}
}
\value{
Returns a numeric vector of probe set means as observed
in the reference data
}
\description{
\code{getMeans} returns the reference means encoded in the
in the classifier.
}
\examples{
aClassifier <- getClassifier("EMC92")
getMeans(aClassifier)
}
\seealso{
showClassifierList getClassifier runClassifier

Other classifier information functions: \code{\link{getCitations}},
  \code{\link{getClassifier}},
  \code{\link{getDecisionBoundaries}},
  \code{\link{getDescription}},
  \code{\link{getEventChain}}, \code{\link{getIntercept}},
  \code{\link{getNormalizationMethod}},
  \code{\link{getProbeNames}}, \code{\link{getSds}},
  \code{\link{getTrainingData}}, \code{\link{getWeights}}
}
\concept{classifier information functions}
