% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allGenericFunctions.R,
%   R/Class_ClassifierParameters.R
\docType{methods}
\name{getIntercept}
\alias{getIntercept}
\alias{getIntercept,ClassifierParameters-method}
\title{Obtain classifiers' intercept.}
\usage{
getIntercept(object)

\S4method{getIntercept}{ClassifierParameters}(object)
}
\arguments{
\item{object}{An object of class \code{\link{ClassifierParameters}}
as returned by \code{\link{getClassifier}}}
}
\value{
A numeric value
}
\description{
\code{getIntercept} returns the numeric value of the
classifier's intercept.
}
\examples{
aClassifier <- getClassifier("EMC92")
getIntercept(aClassifier)
}
\seealso{
Other classifier information functions: \code{\link{getCitations}},
  \code{\link{getClassifier}},
  \code{\link{getDecisionBoundaries}},
  \code{\link{getDescription}},
  \code{\link{getEventChain}}, \code{\link{getMeans}},
  \code{\link{getNormalizationMethod}},
  \code{\link{getProbeNames}}, \code{\link{getSds}},
  \code{\link{getTrainingData}}, \code{\link{getWeights}}
}
\concept{classifier information functions}
