% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allGenericFunctions.R,
%   R/Class_ClassifierParameters.R
\docType{methods}
\name{getEventChain}
\alias{getEventChain}
\alias{getEventChain,ClassifierParameters-method}
\title{Obtain classifiers' event chain.}
\usage{
getEventChain(object)

\S4method{getEventChain}{ClassifierParameters}(object)
}
\arguments{
\item{object}{An object of class \code{\link{ClassifierParameters}}
as returned by \code{\link{getClassifier}}}
}
\value{
Returns the event chain encoded in the
in the classifier encoded as a named list.
}
\description{
\code{getEventChain} returns the event chain encoded in the
in the classifier. The eventchain indicates what preprocessing
steps are performed by the \code{\link{runClassifier}} function
prior to classification.
}
\examples{
aClassifier <- getClassifier("EMC92")
getEventChain(aClassifier)
}
\seealso{
showClassifierList getClassifier runClassifier

Other classifier information functions: \code{\link{getCitations}},
  \code{\link{getClassifier}},
  \code{\link{getDecisionBoundaries}},
  \code{\link{getDescription}}, \code{\link{getIntercept}},
  \code{\link{getMeans}},
  \code{\link{getNormalizationMethod}},
  \code{\link{getProbeNames}}, \code{\link{getSds}},
  \code{\link{getTrainingData}}, \code{\link{getWeights}}
}
\concept{classifier information functions}
