% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allGenericFunctions.R,
%   R/Class_ClassifierParameters.R
\docType{methods}
\name{getDescription}
\alias{getDescription}
\alias{getDescription,ClassifierParameters-method}
\title{Obtain classifiers' description.}
\usage{
getDescription(object)

\S4method{getDescription}{ClassifierParameters}(object)
}
\arguments{
\item{object}{An object of class \code{\link{ClassifierParameters}}
as returned by \code{\link{getClassifier}}}
}
\value{
A character string describing the classifier
}
\description{
\code{getDescription} returns the descriptive text associated
with the classifier.
}
\examples{
aClassifier <- getClassifier("EMC92")
getDescription(aClassifier)
}
\seealso{
Other classifier information functions: \code{\link{getCitations}},
  \code{\link{getClassifier}},
  \code{\link{getDecisionBoundaries}},
  \code{\link{getEventChain}}, \code{\link{getIntercept}},
  \code{\link{getMeans}},
  \code{\link{getNormalizationMethod}},
  \code{\link{getProbeNames}}, \code{\link{getSds}},
  \code{\link{getTrainingData}}, \code{\link{getWeights}}
}
\concept{classifier information functions}
