% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geneAttribution.R
\name{normP}
\alias{normP}
\title{Normalize likelihoods and return probabilities}
\usage{
normP(pVector, minPP = 0)
}
\arguments{
\item{pVector}{A numeric vector of pre-normalization likelihoods}

\item{minPP}{A float. Genes with a posterior probability < minPP are lumped as "Other". Optional}
}
\value{
A sorted, numeric vector of normalized probabilities
}
\description{
Normalize likelihoods and return probabilities
}
\examples{
normP(c(5, 1, 1, 1, 1, 1, 0.1))
normP(c(5, 1, 1, 1, 1, 1, 0.1), minPP=0.1)
}

