% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geneAttribution.R
\docType{package}
\name{geneAttribution}
\alias{geneAttribution}
\alias{geneAttribution-package}
\title{geneAttribution: Identification of candidate genes associated with noncoding genetic variation}
\usage{
geneAttribution(chr, pos, geneCoordinates, empiricalData, lambda = 7.61e-06,
  maxDist = 1e+06, minPP = 0.01)
}
\arguments{
\item{chr}{A character string representing a chromosome (e.g. "chr2")}

\item{pos}{An integer representing a genomic position in the same genome build that gene models}

\item{geneCoordinates}{A GenomicRanges object, as generated by geneModels()}

\item{empiricalData}{A list of GenomicRanges objects, as generated by loadBed(). Optional}

\item{lambda}{Float. Variable for exponential distribution. Default based on empirical eQTL data from multiple tissues. Optional}

\item{maxDist}{Integer. Only genes within this distance of query locus are considered. Optional}

\item{minPP}{Float. Genes with a posterior probability < minPP are lumped as "Other". Can be set to 0 when all genes should be reported. Optional}
}
\value{
A sorted, numeric vector of normalized gene probabilities
}
\description{
Identification of the most likely gene or genes through which variation at a given genomic
locus in the human genome acts. The most basic functionality assumes that the closer gene is
to the input locus, the more likely the gene is to be causative. Additionally, any empirical
data that links genomic regions to genes (e.g. eQTL or genome conformation data) can be used
if it is supplied in UCSC .bed file format.
A typical workflow requires loading gene models and empirical data, then running geneAttribution() on the
locus of interest

Given genomic coordinate, return normalized probability for each gene
}
\examples{
geneLocs <- geneModels()
fileName <- system.file("extdata", "eqtlHaplotypeBlocks.b38.bed", package="geneAttribution")
empirical <- loadBed(fileName)
geneAttribution("chr2", 127156000, geneLocs, empirical)
}

