% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_annotation.R
\name{annotate_mae_with_cell_line}
\alias{annotate_mae_with_cell_line}
\title{annotate_mae_with_cell_line}
\usage{
annotate_mae_with_cell_line(mae, cell_line_annotation, fill = "unknown")
}
\arguments{
\item{mae}{MultiAssayExperiment object containing dose-response data}

\item{cell_line_annotation}{data.table with cell line annotations}

\item{fill}{string indicating how unknown cell lines should be filled in the DB}
}
\value{
MultiAssayExperiment object with annotated cell lines
}
\description{
Annotate MultiAssayExperiment object with cell line annotations
}
\examples{
mae <- MultiAssayExperiment::MultiAssayExperiment(
  experiments = list(exp1 = SummarizedExperiment::SummarizedExperiment(
    rowData = data.table::data.table(clid = c("CL1", "CL2", "CL3"))
  ))
)
cell_line_annotation <- get_cell_line_annotation(data.table::as.data.table(
  SummarizedExperiment::rowData(
    MultiAssayExperiment::experiments(mae)[[1]])))
annotated_mae <- annotate_mae_with_cell_line(mae, cell_line_annotation)
}
\keyword{annotation}
