% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotations.R
\name{ct.prepareAnnotation}
\alias{ct.prepareAnnotation}
\title{Check and optionally subset an annotation file for use in a Crispr Screen}
\usage{
ct.prepareAnnotation(ann, object = NULL, controls = TRUE, throw.error = TRUE)
}
\arguments{
\item{ann}{A \code{data.frame} containing an annotation object with gRNA-level information encoded as rows. The 
\code{row.names} attribute should correspond to the individual gRNAs, and it should at minimum contain columns 
named 'geneID' and 'geneSymbol' indicating the corresponding gRNA target gene ID and symbol, respectively.}

\item{object}{If supplied, an object with \code{row.names} to be used to subset the supplied annotation frame
for downstream analysis.}

\item{controls}{The name of a value in the \code{geneSymbol} column of \code{ann} that corresponds to nontargeting 
control gRNAs. May also be supplied as a logical value, in which case the function will try to identify and format 
nontargeting guides.}

\item{throw.error}{Logical indicating whether to throw an error when \code{controls} is \code{TRUE} but no nontargeting
gRNAs are detected.}
}
\value{
A new annotation data frame, usually with nontargeting controls and NA values reformatted to \code{NoTarget} 
(and \code{geneID} set to \code{'no_gid'}),  and the 'geneSymbol' column of \code{ann} factorized. If supplied with 
an \code{object}, the gRNAs not present in the \code{object} will be omitted.
}
\description{
This function processes a supplied annotation object for use in a pooled screening experiment. 
Originally this was processed into something special, but now it essentially returns
the original annotation object in which the geneSymbol column has been factorized. This is primarily used 
internally during a call to the \code{ct.generateResults()} function. Also performs some minor functionality checking, 
and ensures that the reagent identifiers are present as an `ID` column (if absent, the row.names are used).

Valid annotations contain both `geneID` and `geneSymbol` columns. This is because there is often a distinction between
the official gene that is being targeted and a coherent set of gRNAs that make up a testing cohort. For example, 
multiple sets of guides may target distinct promoters, exons, or other entities that are expected to produce distinct 
biological phenomena related to the gene that should be interpreted separately. For this reason, the `geneID` column 
encodes the official gene designation (typically an ensembl or entrez gene identifier) while the `geneSymbol` column
contains a human-readable descriptor of the gRNA target (such as a gene symbol or promoter name). This mapping can be 
further expanded to incorporate mapping ambiguity via the `ct.expandAnnotation()` function.
}
\examples{
data('ann')
data('es')
es <- ct.filterReads(es)
newann <- ct.prepareAnnotation(ann, es)
}
\author{
Russell Bainer
}
