% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Normalization.R
\name{ct.normalizeNTC}
\alias{ct.normalizeNTC}
\title{Normalize sample abundance estimates by the median values of nontargeting control guides}
\usage{
ct.normalizeNTC(eset, annotation, lib.size = NULL, geneSymb = NULL)
}
\arguments{
\item{eset}{An ExpressionSet object containing, at minimum, count data accessible by \code{exprs}.}

\item{annotation}{An annotation dataframe indicating the nontargeting controls in the geneID column.}

\item{lib.size}{An optional vector of voom-appropriate library size adjustment factors, usually calculated with \code{\link[edgeR]{calcNormFactors}} 
and transformed to reflect the appropriate library size. These adjustment factors are interpreted as the total library sizes for each sample, 
and if absent will be extrapolated from the columnwise count sums of the \code{exprs} slot of the \code{eset}.}

\item{geneSymb}{The \code{geneSymbol} identifier in \code{annotation} that corresponds to nontargeting gRNAs. If absent, \code{ct.gRNARankByReplicate} will
attempt to infer nontargeting guides by searching for \code{'no_gid'} or \code{NA} in the appropriate columns via \code{ct.prepareAnnotation()}.}
}
\value{
A normalized \code{eset}.
}
\description{
This function normalizes Crispr gRNA abundance estimates by equalizing the median 
abundances of the nontargeting gRNAs within each sample. The normalized values are returned as normalized counts in 
the '\code{exprs}' slot of the input eset. Note that this method may be unstable if the screening library contains 
relatively few nontargeting gRNAs.
}
\examples{
data('es')
data('ann')

#Build the sample key and library sizes for visualization
library(Biobase)
sk <- ordered(relevel(as.factor(pData(es)$TREATMENT_NAME), 'ControlReference'))
names(sk) <- row.names(pData(es))
ls <- colSums(exprs(es))

es.norm <- ct.normalizeNTC(es, ann, lib.size = ls, geneSymb = 'NoTarget')

ct.gRNARankByReplicate(es, sk, lib.size = ls)
ct.gRNARankByReplicate(es.norm, sk, lib.size = ls)
}
\author{
Russell Bainer
}
