% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GenePvalsFromEset.R
\name{ct.generateResults}
\alias{ct.generateResults}
\title{Calculate results of a crispr screen from a contrast}
\usage{
ct.generateResults(
  fit,
  annotation,
  RRAalphaCutoff = 0.1,
  permutations = 1000,
  contrast.term = NULL,
  scoring = c("combined", "pvalue", "fc"),
  alt.annotation = NULL,
  permutation.seed = NULL
)
}
\arguments{
\item{fit}{An object of class \code{MArrayLM} containing, at minimum, a \code{t} slot with t-statistics from the comparison, 
a \code{df.residual} slot with the corresponding residuals fo the model fits, and an \code{Amean} slot with the respective mean abundances.}

\item{annotation}{An annotation file for the experiment. gRNAs are annotated by 
row, and must minimally contain columns \code{geneSymbol} and \code{geneID}.}

\item{RRAalphaCutoff}{A cutoff to use when defining gRNAs with significantly altered abundance during the RRAa aggregation step, which may be specified
as a single numeric value on the unit interval or as a logical vector. When supplied as a logical vector (of length equal to \code{nrows(fit)}), 
this parameter directly indicates the gRNAs to include during RRAa aggregation. Otherwise, if \code{scoring} is set 
to \code{pvalue} or \code{combined}, this parameter is interpreted as the maximum nominal p-value required to consider a gRNA's abundance meaningfully 
altered during the aggregation step. If \code{scoring} is \code{fc}, this parameter is interpreted as the proportion of the list to be considered 
meaningfully altered in the experiment (e.g., if \code{RRAalphaCutoff} is set to 0.05, only consider the rankings of the 5% most upregulated 
(or downregulated) gRNAs for the purposes of RRAa calculations).

Note that this function uses directional tests to identify enriched or depleted targets, and when RRAalphaCutoff is 
provided as a logical vector the interpretation of the various aggregation statistics is going to be dependent on the specific criteria 
used to select reagents for inclusion.}

\item{permutations}{The number of permutations to use during the RRAa aggregation step.}

\item{contrast.term}{If a fit object with multiple coefficients is passed in, a string indiating the coefficient of interest.}

\item{scoring}{The gRNA ranking method to use in RRAa aggregation. May take one of three values: \code{pvalue}, \code{fc},
or '\code{combined}'. \code{pvalue} indicates that the gRNA ranking statistic should be created from the (one-sided) p-values in the 
fit object. \code{fc} indicates that the ranks of the gRNA coefficients should be used instead, and \code{combined} indicates that 
that the coefficents should be used as the ranking statistic but gRNAs are discarded in the aggregation step based on the corresponding nominal 
p-value in the fit object.}

\item{alt.annotation}{Libraries targeting ambiguous biological elements (e.g., alternative promoters to a gene where the boundaries between
elelments is contested) may contain reagents that are plausibly annotated to a finite set of possible targets. To accomodate this, users may 
supply an alternative reagent annotation in the form of a named list of vectors, where each list element corresponds something coercible to a to
a character vector of associated targets that will ultimately be assembled into the `geneSymbol` column of the `resultsDF` object. Each of these 
character vectors should be named identically to a row of the supplied fit object (e.g., the `row.names`). It is assumed that the `geneID` values 
are assigned unambiguously to the reagents, and are passed through directly.}

\item{permutation.seed}{numeric seed for permutation reproducibility. 
Default: \code{NULL} means to not set any seed. This argument is passed
through to \code{\link{ct.RRAaPvals}}.}
}
\value{
A dataframe containing gRNA-level and target-level statistics. In addition to the information present in the supplied annotation object, 
the returned object indicates P-values and Q-values for the depletion and enrichment of each gRNA and associated target, the median log2 fold 
change estimate among all gRNAs associated with the target, and Rho statistics that are calculated internally by the RRAa algorithm that may be 
useful in ranking targets that are considered significant at a given alpha or false discovery threshold.

A `resultsDF` formatted dataframe containing gene-level statistics.
}
\description{
This is a wrapper function that enables direct generation of target-level p-values from a crispr screen.
}
\examples{
data('fit')
data('ann')
output <- ct.generateResults(fit, ann, permutations = 10)
head(output)
  p = seq(0, 1, length.out=20)
  fc = seq(-3, 3, length.out=20)
  fc[2] = NA
  fc[3] = -20
  stats = data.frame(
    Depletion.P=p,
    Enrichment.P=rev(p),
    fc=fc
  )
  ct.applyAlpha(stats,scoring='combined')
}
\author{
Russell Bainer
}
