% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AlignmentBarchart.R
\name{ct.alignmentChart}
\alias{ct.alignmentChart}
\title{View a Barchart Summarizing Alignment Statistics for a Crispr Screen}
\usage{
ct.alignmentChart(aln, sampleKey = NULL)
}
\arguments{
\item{aln}{A numeric matrix of alignment statistics for a Crispr experiment. Corresponds to a 4xN matrix of read counts, with columns indicating 
samples and rows indicating the number of 'targets', 'nomatch', 'rejections', and 'double_match' reads. Details about these classes may be found 
in the best practices vignette or as part of the report generated with \code{ct.makeReport()}.}

\item{sampleKey}{An optional ordered factor linking the samples to experimental variables. The \code{names} attribute should exactly match those present in \code{aln}.}
}
\value{
A grouped barplot displaying the alignment statistics for each sample included in the alignment matrix, which usually corresponds to all of 
the samples in the experiment.
}
\description{
This function displays the alignemnt statistics for a pooled Crispr screen, reported directly from an alignment statistic matrix.
}
\examples{
data('aln')
ct.alignmentChart(aln)
}
\author{
Russell Bainer
}
