% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frenchfish.R
\name{getManualCountsEstimates}
\alias{getManualCountsEstimates}
\title{FrenchFISH function for generating volume adjusted spot counts from spots
which have been manually counted (uses a Markov chain Monte Carlo method).}
\usage{
getManualCountsEstimates(probeCounts, radius, height)
}
\arguments{
\item{probeCounts}{A matrix of manual spot counts with columns for 
probes and rows for nuclei}

\item{radius}{The cells' nuclear radius (must be measured in same unit as 
\code{height})}

\item{height}{The section height (must be measured in same unit as 
\code{radius})}
}
\value{
The volume adjusted spot counts for each probe that have been 
generated using MCMC modelling
}
\description{
FrenchFISH function for generating volume adjusted spot counts from spots
which have been manually counted (uses a Markov chain Monte Carlo method).
}
\examples{
manualCountsEstimates<-getManualCountsEstimates(cbind(red=c(0,2,4),
    green=c(5,3,1), blue=c(3,0,2)), 8, 4)
}
