% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxiliary.R
\name{select.Frames}
\alias{select.Frames}
\title{Extracts subsets of frames from a \code{Frames} object}
\usage{
select.Frames(frames, framesToKeep = 1, ...)
}
\arguments{
\item{frames}{A \code{Frames} object}

\item{framesToKeep}{A vector containing the indexes of the frames to keep in the selection}

\item{...}{Arguments to be passed to methods}
}
\value{
A \code{Frames} object, composed by the subset of frames of the input \code{Frames}
}
\description{
An input \code{Frames} object is subject to subsetting. This function is useful e.g. when the trajectory of interest
is presenting gaps (i.e. does not actually include a frame)
}
\examples{
data("MesenteriumSubset")
select.Frames(MesenteriumSubset, framesToKeep = c(1:10, 14:20))

}
\author{
Federico Marini, \email{marinif@uni-mainz.de}, 2014
}
