% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxiliary.R
\name{export.Frames}
\alias{export.Frames}
\title{Exports a \code{Frames} object}
\usage{
export.Frames(
  frames,
  dir = tempdir(),
  nameStub = "testExport",
  createGif = FALSE,
  removeAfterCreatingGif = TRUE
)
}
\arguments{
\item{frames}{A \code{Frames} object}

\item{dir}{The path of the folder where the image should be written}

\item{nameStub}{The stub for the file name, that will be used as a prefix for the exported images}

\item{createGif}{Logical, whether to create or not an animated .gif file}

\item{removeAfterCreatingGif}{Logical, whether to remove the single exported .png images after creating the single .gif}
}
\value{
Image files are written in the desired location
}
\description{
Writes the images contained in the \code{image} slot of the \code{Frames} object elements.
The images can be exported as single frames, or as a .gif image that is composed
by the single frames.
}
\examples{
data("MesenteriumSubset")
\dontrun{export.Frames(MesenteriumSubset,nameStub="subset_export_",
                       createGif=TRUE,removeAfterCreatingGif=FALSE)}

}
\author{
Federico Marini, \email{marinif@uni-mainz.de}, 2014
}
