% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setGate_Methods.R
\name{gs_pop_set_gate}
\alias{gs_pop_set_gate}
\alias{gh_pop_set_gate}
\alias{setGate}
\alias{setGate,GatingHierarchy,character,filter-method}
\alias{setGate,GatingSet,character,ANY-method}
\title{update the gate}
\usage{
gh_pop_set_gate(obj, y, value, negated = FALSE, ...)

gs_pop_set_gate(obj, y, value, ...)
}
\arguments{
\item{obj}{\code{GatingHierarchy} or \code{GatingSet}}

\item{y}{\code{character} node name or path}

\item{value}{\code{filter} or \code{filterList} or \code{list} of \code{filter} objects}

\item{negated}{\code{logical} see \link{add}}

\item{...}{other aguments}
}
\description{
update the population node with a flowCore-compatible gate object
}
\details{
Usually \link{recompute} is followed by this call since updating a gate
doesn't re-calculating the cell events within the gate automatically.
see \link{filterObject} for the gate types that are currently supported.
}
\examples{
\dontrun{  
rg1 <- rectangleGate("FSC-H"=c(200,400), "SSC-H"=c(250, 400), filterId="rectangle")
rg2 <- rectangleGate("FSC-H"=c(200,400), "SSC-H"=c(250, 400), filterId="rectangle")
flist <- list(rg1,rg2)
names(flist) <- sampleNames(gs[1:2])
gs_pop_set_gate(gs[1:2], "lymph", flist)
recompute(gs[1:2], "lymph") 
}
}
