% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GatingSetList_Methods.R
\docType{class}
\name{GatingSetList-class}
\alias{GatingSetList-class}
\alias{GatingSetList}
\title{Class \code{"GatingSetList"}}
\usage{
GatingSetList(x, samples = NULL)
}
\arguments{
\item{x}{a \code{list} of \code{GatingSet}}

\item{samples}{\code{character} vector specifying the order of samples.
if not specified, the samples are ordered as the underlying stored order.}
}
\description{
A list of of \code{GatingSet} objects. This class exists for method dispatching.

use \code{GatingSetList} constructor to create a GatingSetList from a list of GatingSet
}
\details{
Objects store a collection of GatingSets,which usually has the same gating trees and markers.
  Most GatingSets methods can be applied to GatingSetList.
}
\examples{
  \dontrun{
    #load several GatingSets from disk
   gs_list<-lapply(list.files("../gs_toMerge",full=T) ,function(this_folder){
                     load_gs(this_folder)
                     })
    
   #gs_list is a list
    gs_groups <- merge(gs_list)
    #returns a list of GatingSetList objects
    gslist2 <- gs_groups[[2]]
    #gslist2 is a GatingSetList that contains multiple GatingSets and they share the same gating and data structure
    gslist2
    class(gslist2)
    sampleNames(gslist2)
    
    #reference a GatingSet by numeric index
    gslist2[[1]]
    #reference a GatingSet by character index
    gslist2[["30104.fcs"]]
    
    #loop through all GatingSets within GatingSetList
    lapply(gslist2,sampleNames)
    
    #subset a GatingSetList by [
    sampleNames(gslist2[c(4,1)])
    sampleNames(gslist2[c(1,4)])
    gslist2[c("30104.fcs")]
    
    #get flow data from it
    gs_pop_get_data(gslist2)
    #get gated flow data from a particular popoulation 
    gs_pop_get_data(gslist2, "3+")
    
    #extract the gates associated with one popoulation
    gs_pop_get_gate(gslist2,"3+")
    gs_pop_get_gate(gslist2,5)
    
    #extract the pheno data
    pData(gslist2[3:1])
    #modify the pheno data
    pd <- pData(gslist2)
    pd$id <- 1:nrow(pd)
    pData(gslist2) <- pd
    pData(gslist2[3:2])

    #plot the gate
    autoplot(gslist2[1:2],5)
    
    #remove cerntain gates by loop through GatingSets
    gs_get_pop_paths(gslist2[[1]])
    lapply(gslist2,function(gs)gs_pop_remove("Excl",gs = gs))
    
    #extract the stats
    gs_pop_get_count_fast(gslist2)
    #extract statistics by using getQAStats defined in QUALIFIER package
    res<-getQAStats(gslist2[c(4,2)],isMFI=F,isSpike=F,nslaves=1)
    
    #archive the GatingSetList
    save_gslist(gslist2, path ="~/rglab/workspace/flowIncubator/output/gslist",overwrite=T)
    gslist2 <- load_gslist(path ="~/rglab/workspace/flowIncubator/output/gslist")
    
    #convert GatingSetList into one GatingSet by merge_list_to_gs
    gs_merged2 <- merge_list_to_gs(gslist2)
    gs_merged2
  }

\dontrun{
samleNames(gsA) # return A1, A2
samleNames(gsB) # return B1, B2
gs.list <- list(gsA, gsB)
gslist<- GatingSetList(gs.list)
sampleNames(gslist) #return A1,A2,B1,B2

#set different order when create the GatingSetList
gslist<- GatingSetList(gs.list, samples = c("A1","B1", "A2", "B2"))
sampleNames(gslist) #return A1,B1,A2,B2
}
}
\seealso{
\code{\linkS4class{GatingSet}}
  \code{\linkS4class{GatingHierarchy}}
}
