% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mkPriors.R
\name{mkPrior}
\alias{mkPrior}
\alias{mkPrior,list,flowSet,missing,missing-method}
\alias{mkPrior,polygonGate,flowFrame,numeric,matrix-method}
\alias{mkPrior,rectangleGate,flowFrame,numeric,matrix-method}
\alias{mkPrior,rectangleGate,flowFrame,missing,missing-method}
\alias{mkPrior,polygonGate,flowFrame,missing,missing-method}
\alias{mkPrior,missing,flowSet,ANY,missing-method}
\alias{mkPrior,missing,flowFrame,missing,missing-method}
\alias{mkPrior,list,flowSet,ANY,missing-method}
\title{Generate a flowClust prior specification}
\usage{
mkPrior(gate, data, nu0, Omega0, ...)

\S4method{mkPrior}{polygonGate,flowFrame,numeric,matrix}(gate, data, nu0, Omega0)

\S4method{mkPrior}{rectangleGate,flowFrame,numeric,matrix}(gate, data, nu0, Omega0)

\S4method{mkPrior}{rectangleGate,flowFrame,missing,missing}(gate, data, nu0 = NA, Omega0 = NA)

\S4method{mkPrior}{polygonGate,flowFrame,missing,missing}(gate, data, nu0 = NA, Omega0 = NA)

\S4method{mkPrior}{list,flowSet,missing,missing}(gate, data, nu0 = NA, Omega0, model.cov = "full", model.means = "full")

\S4method{mkPrior}{missing,flowSet,ANY,missing}(gate, data, nu0 = NA, Omega0, model.cov = "full", model.means = "full")

\S4method{mkPrior}{missing,flowFrame,missing,missing}(gate, data, nu0, Omega0)

\S4method{mkPrior}{list,flowSet,ANY,missing}(gate, data, nu0 = NA, Omega0, model.cov = "full", model.means = "full")
}
\arguments{
\item{gate}{A list of flowCore gates. The gates should represent the SAME
population gated across multiple samples.}

\item{data}{A flowSet of the same size as the number of gates above. Each
flowFrame in the flowSet should contain the events representing the
population in its corresponding gate. i.e. it should be the gated data.}

\item{nu0}{The nu0 hyperparameter. For estimation from data, it should be
nu0=NA.}

\item{Omega0}{The Omega0 hyperparameter. For estimation from data it can be
missing.}

\item{\dots}{Not currently used.}

\item{model.cov, model.means}{model names used for cov and means. one of c("full","DE","DU").
"full" is the default.}
}
\value{
Return values depend on the specific method called. Not meant for
user consumption.
}
\description{
Generate a flowClust prior specification from gates and data
}
\details{
Construct a prior specification. Generally not called by the user.
}
\examples{

## The function is currently defined as
}
\references{
\url{http://www.rglab.org}
}
\author{
Greg Finak \email{gfinak@fhcrc.org}
}
