% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corrMatCreate.R
\name{corrMatCreate}
\alias{corrMatCreate}
\title{Generate a correction matrix for cytometry data analysis}
\usage{
corrMatCreate(specMat)
}
\arguments{
\item{specMat}{The spectral matrix used to unmix the dataset of interest.}
}
\value{
A symmetrical matrix of zeros with the right row- and column names.
}
\description{
This function aids the correctUnmix function, to create a symmetrical
correction matrix that should be used together with a flowframe to correct
the errors of unmixing.
}
\examples{
# Load uncompensated data
data(fullPanel)

# Load the spectral unmixing matrix generated with controls from the same
# experiment. These can be generated using the specMatCalc function.
data(specMat)

# And now unmix
fullPanelUnmix <- specUnmix(fullPanel, specMat)


# Create an empty unmixinng matrix
corrMat <- corrMatCreate(specMat)

}
\seealso{
\code{\link{correctUnmix}}
}
