% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_flowgraph_features.R
\name{fg_feat_node_prop}
\alias{fg_feat_node_prop}
\title{Generates the proportion node feature.}
\usage{
fg_feat_node_prop(fg, overwrite = FALSE)
}
\arguments{
\item{fg}{flowGraph object.}

\item{overwrite}{A logical variable indicating whether to
overwrite the existing proportion node feature if it exists.}
}
\value{
flowGraph object containing the proportion node feature.
}
\description{
Generates the proportion node feature and returns it
 inside the returned flowGraph object.
}
\details{
Given a flowGraph object, \code{fg_feat_node_prop} returns the same
 flowGraph object, inside of which is an additional proportions \code{prop}
 \code{node} feature
 and its meta data. The proportions feature is made using the node count
 feature and is the cell count of each cell population over the total
 cell count.
}
\examples{

 no_cores <- 1
 data(fg_data_pos30)
 fg <- flowGraph(fg_data_pos30$count, class=fg_data_pos30$meta$class,
                 prop=FALSE, specenr=FALSE,
                 no_cores=no_cores)

 fg <- fg_feat_node_prop(fg)

}
\seealso{
\code{\link[flowGraph]{flowGraph-class}}
 \code{\link[flowGraph]{fg_feat_node_specenr}}
 \code{\link[flowGraph]{fg_add_feature}}
 \code{\link[flowGraph]{fg_get_feature}}
 \code{\link[flowGraph]{fg_rm_feature}}
 \code{\link[flowGraph]{fg_get_feature_desc}}
}
