% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SetMethods.R
\docType{methods}
\name{Map,flowClust-method}
\alias{Map,flowClust-method}
\alias{Map,flowClustList-method}
\alias{Map.flowClust}
\alias{Map}
\title{Cluster Assignment Based on Clustering Results}
\usage{
Map(f, ...)

\S4method{Map}{flowClust}(f, rm.outliers = TRUE, ...)

\S4method{Map}{flowClustList}(f, rm.outliers = TRUE, ...)
}
\arguments{
\item{f}{Object returned from \code{\link{flowClust}} or
\code{\link[=tmixFilter]{filter}}.}

\item{\dots}{Further arguments to be passed to or from other methods.}

\item{rm.outliers}{A logical value indicating whether outliers will be left
unassigned or not.}
}
\value{
A numeric vector of size \eqn{N} (the number of observations)
indicating to which cluster each observation is assigned.  Unassigned
observations will be labelled as \code{NA}.
}
\description{
This method performs cluster assignment according to the posterior
probabilities of clustering memberships resulted from the clustering
(filtering) operations.  Outliers identified will be left unassigned by
default.
}
\note{
Even if \code{rm.outliers} is set to \code{FALSE}, \code{NA} may still
appear in the resultant vector due to the filtered observations; see the
descriptions about the \code{min.count}, \code{max.count}, \code{min} and
\code{max} arguments of \code{\link{flowClust}}.
}
\references{
Lo, K., Brinkman, R. R. and Gottardo, R. (2008) Automated Gating
of Flow Cytometry Data via Robust Model-based Clustering. \emph{Cytometry A}
\bold{73}, 321-332.
}
\seealso{
\code{\link{flowClust}}, \code{\link[=tmixFilter]{filter}},
\code{\link{posterior}}
}
\author{
Raphael Gottardo <\email{raph@stat.ubc.ca}>, Kenneth Lo
<\email{c.lo@stat.ubc.ca}>
}
\keyword{cluster}
