% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotRankScatters.R
\name{plotRankScatters}
\alias{plotRankScatters}
\title{Visualize the unweighted rank changes}
\usage{
plotRankScatters(obj, top = TRUE, points.arg = list(), top.arg = list())
}
\arguments{
\item{obj}{the objective obtained from \code{findIPs()} or \code{sumRanks()}
functions}

\item{top}{logical, whether the most influential case needs to be plot in
black}

\item{points.arg}{a list. Arguments in \code{graphics::points()} can be used
to define the points.}

\item{top.arg}{a list. Arguments in \code{graphics::points()} can be used
to define the top points.}
}
\value{
a plot based on basic graphic.
}
\description{
Visualize the unweighted rank changes using scatter plot. The plot displays
the original ranking and leave-one-out rankings.
}
\examples{

data(miller05)
X <- miller05$X
y <- miller05$y

obj <- getdrop1ranks(X, y,
                     fun = 't.test',
                     decreasing = FALSE,
                     topN = 100)
rks <- sumRanks(origRank = obj$origRank,
                drop1Rank = obj$drop1Rank,
                topN = 100,
                method = 'adaptive')
plotRankScatters(rks)

}
