% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotIPs.R
\name{plotIPs}
\alias{plotIPs}
\title{Visualize the influential scores}
\usage{
plotIPs(obj, topn = 5, ylim = NULL, ...)
}
\arguments{
\item{obj}{the object obtained from \code{rank.compare} or \code{findIPs}
function.}

\item{topn}{the top n most influential points to be labelled in the plot.}

\item{ylim}{y coordinates ranges}

\item{...}{other arguments}
}
\value{
plot based on basic graph
}
\description{
Visualize influential score using lollipop plot. The function uses the output
obtained from \code{rank.compare} or \code{findIPs} function.
}
\examples{

data(miller05)
X <- miller05$X
y <- miller05$y
obj <- getdrop1ranks(X, y,
                     fun = 't.test',
                     decreasing = FALSE,
                     topN = 100)
rks <- sumRanks(origRank = obj$origRank,
                drop1Rank = obj$drop1Rank,
                topN = 100,
                method = 'adaptive')
plotIPs(rks, topn = 5, ylim = NULL)

}
