% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geseca-simple.R
\name{gesecaSimple}
\alias{gesecaSimple}
\title{Runs simple variant for performing gene sets co-regulation analysis}
\usage{
gesecaSimple(
  pathways,
  E,
  minSize = 1,
  maxSize = nrow(E) - 1,
  center = TRUE,
  scale = FALSE,
  nperm = 1000,
  nproc = 0,
  BPPARAM = NULL
)
}
\arguments{
\item{pathways}{List of gene sets to check.}

\item{E}{expression matrix, rows corresponds to genes, columns corresponds to samples.}

\item{minSize}{Minimal size of a gene set to test. All pathways below the threshold are excluded.}

\item{maxSize}{Maximal size of a gene set to test. All pathways above the threshold are excluded.}

\item{center}{a logical value indicating whether the gene expression should be centered to have zero mean before the analysis takes place.
The default is TRUE. The value is passed to \link[base]{scale}.}

\item{scale}{a logical value indicating whether the gene expression should be scaled to have unit variance before the analysis takes place.
The default is FALSE. The value is passed to \link[base]{scale}.}

\item{nperm}{Number of permutations to do. Minimal possible nominal p-value is about 1/nperm}

\item{nproc}{If not equal to zero sets BPPARAM to use nproc workers (default = 0).}

\item{BPPARAM}{Parallelization parameter used in bplapply.}
}
\value{
A table with GESECA results. Each row corresponds to a tested pathway. The columns are the following
\itemize{
\item pathway -- name of the pathway as in `names(pathways)`;
\item pctVar -- percent of explained variance along gene set;
\item pval -- P-value that corresponds to the gene set score;
\item padj -- a BH-adjusted p-value;
\item size -- size of the pathway after removing genes not present in `rownames(E)`.
}
}
\description{
This function is based on the rude Monte Carlo sampling approach
and P-value calculation accuracy is limited to `1 / nperm` value.
}
\examples{
data("exampleExpressionMatrix")
data("examplePathways")
gesecaRes <- gesecaSimple(examplePathways, exampleExpressionMatrix, minSize=15, maxSize=500)
}
