% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{calcGseaStatBatchCpp}
\alias{calcGseaStatBatchCpp}
\title{Calculates GSEA statistic valus for all gene sets in `selectedStats` list.}
\usage{
calcGseaStatBatchCpp(stats, selectedGenes, geneRanks)
}
\arguments{
\item{stats}{Numeric vector of gene-level statistics sorted in decreasing order}

\item{selectedGenes}{List of integer vector with integer gene IDs (from 1 to n)}

\item{geneRanks}{Integer vector of gene ranks}
}
\value{
Numeric vector of GSEA statistics of the same length as `selectedGenes` list
}
\description{
Takes \emph{O(n + mKlogK)} time, where n is the number of genes, m is the number of gene sets,
and k is the mean gene set size.
}
