% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fgsea.R
\name{collapsePathways}
\alias{collapsePathways}
\title{Collapse list of enriched pathways to independent ones.}
\usage{
collapsePathways(
  fgseaRes,
  pathways,
  stats,
  pval.threshold = 0.05,
  nperm = 10/pval.threshold,
  gseaParam = 1
)
}
\arguments{
\item{fgseaRes}{Table with results of running fgsea(), should be filtered
by p-value, for example by selecting ones with padj < 0.01.}

\item{pathways}{List of pathways, should contain all the pathways present in
`fgseaRes`.}

\item{stats}{Gene-level statistic values used for ranking, the same as
in `fgsea()`.}

\item{pval.threshold}{Two pathways are considered dependent when p-value
of enrichment of one pathways on background of another
is greater then `pval.threshold`.}

\item{nperm}{Number of permutations to test for independence, should be
several times greater than `1/pval.threhold`.
Default value: `10/pval.threshold`.}

\item{gseaParam}{GSEA parameter, same as for `fgsea()`}
}
\value{
Named list with two elments: `mainPathways` containing IDs of pathways
        not reducable to each other, and `parentPathways` with vector describing
        for all the pathways to which ones they can be reduced. For
        pathways from `mainPathwyas` vector `parentPathways` contains `NA` values.
}
\description{
Collapse list of enriched pathways to independent ones.
}
\examples{
data(examplePathways)
data(exampleRanks)
fgseaRes <- fgsea(examplePathways, exampleRanks, nperm=10000, maxSize=500)
collapsedPathways <- collapsePathways(fgseaRes[order(pval)][padj < 0.01],
                                      examplePathways, exampleRanks)
mainPathways <- fgseaRes[pathway \%in\% collapsedPathways$mainPathways][
                         order(-NES), pathway]
}
