% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bioplanet.R
\name{fetch_bp}
\alias{fetch_bp}
\title{Get functional term data from BioPlanet}
\usage{
fetch_bp(use_cache = TRUE, on_error = c("stop", "warn", "ignore"))
}
\arguments{
\item{use_cache}{Logical, if TRUE, the remote file will be cached locally.}

\item{on_error}{A character string indicating the error handling strategy:
either "stop" to halt execution, "warn" to issue a warning and return
`NULL` or "ignore" to return `NULL` without warnings. Defaults to "stop".}
}
\value{
A list with \code{terms} and \code{mapping} tibbles.
}
\description{
Download term information (term ID and name) and gene-pathway mapping
(NCBI gene ID, gene symbol and pathway ID) from BioPlanet.
}
\examples{
bioplanet_data <- fetch_bp(on_error = "warn")
}
