/*
 * Decompiled with CFR 0.152.
 */
package com.gkano.bioinfo.fasta;

import com.gkano.bioinfo.fasta.FastaManager;
import com.gkano.bioinfo.fasta.Sequence;
import com.gkano.bioinfo.fasta.SequenceD2;
import com.gkano.bioinfo.fasta.SequenceEncoder;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;

public class SequenceProcessor
implements Runnable {
    private static AtomicInteger sequenceCount = new AtomicInteger(0);
    private static AtomicInteger taskCount = new AtomicInteger(0);
    private final int id = taskCount.getAndIncrement();
    private FastaManager frm = null;
    private int k;
    private boolean normalize;
    private CountDownLatch startSignal = null;
    private CountDownLatch doneSignal = null;
    private boolean verbose = false;
    private ConcurrentHashMap<Integer, SequenceD2> seqVectors;

    public static void resetCounters() {
        sequenceCount = new AtomicInteger(0);
        taskCount = new AtomicInteger(0);
    }

    public SequenceProcessor(ConcurrentHashMap<Integer, SequenceD2> seqVectors, FastaManager frm, int k, boolean normalize, CountDownLatch startSignal, CountDownLatch doneSignal, boolean verbose) {
        this.seqVectors = seqVectors;
        this.frm = frm;
        this.k = k;
        this.normalize = normalize;
        this.startSignal = startSignal;
        this.doneSignal = doneSignal;
        this.verbose = verbose;
    }

    public static AtomicInteger getSequenceCount() {
        return sequenceCount;
    }

    public void setStartSignal(CountDownLatch startSignal) {
        this.startSignal = startSignal;
    }

    public void setDoneSignal(CountDownLatch doneSignal) {
        this.doneSignal = doneSignal;
    }

    public int getId() {
        return this.id;
    }

    @Override
    public void run() {
        try {
            this.startSignal.await();
            boolean done = false;
            while (!done) {
                Sequence sequence = this.frm.getNextSequence();
                SequenceD2 sequenceD2 = null;
                if (sequence != null) {
                    sequenceD2 = new SequenceD2(sequence);
                    sequenceD2.getName();
                    sequenceD2.getShortName();
                }
                if (sequenceD2 == null) {
                    if (this.frm.hasMore()) continue;
                    done = true;
                    break;
                }
                sequenceCount.incrementAndGet();
                int i = 0;
                while (i + this.k <= sequenceD2.getLength()) {
                    int oldAs = sequenceD2.as;
                    int oldTs = sequenceD2.ts;
                    int oldCs = sequenceD2.cs;
                    int oldGs = sequenceD2.gs;
                    long kmerCode = SequenceEncoder.encodeToLong(sequenceD2, i, i + this.k, false, true);
                    if (kmerCode >= 0L) {
                        sequenceD2.insertKmerCount(kmerCode, 1);
                        sequenceD2.insertKmerProb(kmerCode, (short)(sequenceD2.as - oldAs), (short)(sequenceD2.ts - oldTs), (short)(sequenceD2.cs - oldCs), (short)(sequenceD2.gs - oldGs));
                    }
                    oldAs = sequenceD2.as;
                    oldTs = sequenceD2.ts;
                    oldCs = sequenceD2.cs;
                    oldGs = sequenceD2.gs;
                    kmerCode = SequenceEncoder.encodeToLong(sequenceD2, i, i + this.k, true, true);
                    if (kmerCode >= 0L) {
                        sequenceD2.insertKmerCount(kmerCode, 1);
                        sequenceD2.insertKmerProb(kmerCode, (short)(sequenceD2.as - oldAs), (short)(sequenceD2.ts - oldTs), (short)(sequenceD2.cs - oldCs), (short)(sequenceD2.gs - oldGs));
                    }
                    ++i;
                }
                double sumprob = sequenceD2.calculateProbs(this.k);
                if (this.normalize) {
                    sequenceD2.normalizeProbs(sequenceD2.getNorm());
                }
                SequenceD2 seqVector = sequenceD2;
                this.seqVectors.put(seqVector.getSequenceId(), seqVector);
                if (this.verbose) {
                    System.err.println(sequenceCount.get() + "\t" + seqVector.getShortName());
                }
                sequenceD2.clearHeadSeq();
            }
            this.doneSignal.countDown();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

