% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-FAERS.R
\name{faers_get}
\alias{faers_get}
\alias{faers_get,FAERSascii-method}
\alias{faers_mget}
\alias{faers_mget,FAERSascii-method}
\alias{faers_primaryid}
\alias{faers_primaryid,FAERSascii-method}
\alias{[,FAERSascii,ANY,ANY,ANY-method}
\alias{[,FAERSascii-method}
\alias{[[,FAERSascii-method}
\alias{$,FAERSascii-method}
\alias{faers_keep}
\alias{faers_keep,FAERSascii-method}
\alias{faers_filter}
\alias{faers_filter,FAERSascii-method}
\alias{faers_modify}
\alias{faers_modify,FAERSascii-method}
\title{Methods for FAERS class}
\usage{
faers_get(object, ...)

\S4method{faers_get}{FAERSascii}(object, field)

faers_mget(object, ...)

\S4method{faers_mget}{FAERSascii}(object, fields)

faers_primaryid(object, ...)

\S4method{faers_primaryid}{FAERSascii}(object)

\S4method{[}{FAERSascii,ANY,ANY,ANY}(x, i)

\S4method{[[}{FAERSascii}(x, i)

\S4method{$}{FAERSascii}(x, name)

faers_keep(object, ...)

\S4method{faers_keep}{FAERSascii}(object, primaryid = NULL, invert = FALSE)

faers_filter(.object, ...)

\S4method{faers_filter}{FAERSascii}(.object, .fn, ..., .field = NULL, .invert = FALSE)

faers_modify(.object, ...)

\S4method{faers_modify}{FAERSascii}(.object, .field, .fn, ...)
}
\arguments{
\item{object, .object}{A \link{FAERSascii} object.}

\item{...}{Other arguments passed to specific methods. For \code{faers_filter}:
other arguments passed to \code{.fn}.}

\item{field}{A string indicates the FAERS fields to use. Only values
"demo", "drug", "indi", "reac", "ther", "rpsr", and "outc" can be used.}

\item{fields}{A character vector specifying the fields to use. Only values
"demo", "drug", "indi", "ther", "reac", "rpsr", and "outc" can be used.}

\item{x}{A \link{FAERSascii} object.}

\item{i, name}{Indices specifying elements to extract. For \code{i}, it will be
okay to use integer indices.}

\item{primaryid}{An atomic character or integer specifies the reports to
keep. If \code{NULL}, will do nothing.}

\item{invert}{A bool. If \code{TRUE}, will keep reports not in \code{primaryid}.}

\item{.fn}{A function or formula, accept the field data as the input and
return an atomic integer or character of \code{primaryid} you want to keep or
remove based on argument \code{.invert}.

If a \strong{function}, it is used as is.

If a \strong{formula}, e.g. \code{~ .x + 2}, it is converted to a function with up to
two arguments: \code{.x} (single argument) or \code{.x} and \code{.y} (two arguments). The
\code{.} placeholder can be used instead of \code{.x}.  This allows you to create
very compact anonymous functions (lambdas) with up to two inputs.

If a \strong{string}, the function is looked up in \code{globalenv()}.}

\item{.field}{A string indicating the FAERS data to be used as input for the
\code{.fn} function to extract the primaryid or modify data. Only the following
values can be used: "demo", "drug", "indi", "ther", "reac", "rpsr", and
"outc".
\itemize{
\item \code{faers_filter}: Use \code{.fn} to extract primaryid. If \code{NULL}, \code{.object} will
be passed directly to \code{.fn}. \code{.fn} should return an atomic integer or
character of primaryid that you want to keep or remove based on the
\code{.invert} argument.
\item \code{faers_modify}: Use \code{.fn} to modify the specified field data. You cannot
use \code{NULL} here. \code{.fn} should always return a
\link[data.table:data.table]{data.table}.
}}

\item{.invert}{A bool. If \code{TRUE}, will keep reports not returned by \code{.fn}.}
}
\value{
See details.
}
\description{
Utils function for \link{FAERSascii} class.
}
\details{
\itemize{
\item \code{faers_get}: Extract a specific field
\link[data.table:data.table]{data.table}. For \code{reac} and \code{indi} field, meddra
data will be automatically added if avaliable.
\item \code{faers_mget}: Extract a list of field
\link[data.table:data.table]{data.table}. For \code{reac} and \code{indi} field, meddra
data will be automatically added if avaliable.
\item \code{[[}, \code{$}, and \code{[}: Extract a specific field
\link[data.table:data.table]{data.table} or a list of field
\link[data.table:data.table]{data.table} from \link{FAERS} object. Note: this just
extract field data from \verb{@data} slot directly. For usual usage, just use
\code{faers_get} or \code{faers_mget}.
\item \code{faers_primaryid}: Extract the \code{primaryid} from \code{demo} field.
\item \code{faers_keep}: only keep data from specified \code{primaryid}. Note: \code{year},
\code{quarter}, \code{deletedCases} will be kept as the original. So make sure you
didn't filter a whole period FAERS quarterly data, in this way, it's much
better to run \link[=FAERS]{faers}.
\item \code{faers_filter}: apply a function to extract the wanted \code{primaryid}, then
use \code{faers_keep} to keep data from these primaryids.
}
}
\examples{
# you must change `dir`, as the file included in the package is sampled
data <- faers(2004, "q1",
    dir = system.file("extdata", package = "faers"),
    compress_dir = tempdir()
)
faers_get(data, "indi")
data[["indi"]]
data$indi
faers_get(data, "demo")
data[["demo"]]
data$demo
faers_mget(data, c("indi", "drug"))
faers_mget(data, c("indi", "demo"))
faers_primaryid(data)
faers_keep(data, primaryid = sample(faers_primaryid(data), 20L))
faers_filter(data, .fn = function(x) {
    sample(x$primaryid, 100L)
}, .field = "demo")
}
