% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/defineSeqinfo.R
\name{defineSeqinfo}
\alias{defineSeqinfo}
\title{Use package data to define a Seqinfo object}
\usage{
defineSeqinfo(
  build = c("GRCh38", "GRCh37", "GRCm39", "GRCm38", "hg19", "hg38", "T2T-CHM13v2.0",
    "mm39", "mm10"),
  chr = TRUE,
  mito,
  ...
)
}
\arguments{
\item{build}{The Genome build used}

\item{chr}{logical(1) Include the prefix "chr"}

\item{mito}{Specify M or MT to include the mitochondrial chromosome. Omitted
by default}

\item{...}{Not used}
}
\value{
A Seqinfo object
}
\description{
Use package data to define a Seqinfo object
}
\details{
This function will create a Seqinfo object from pre-defined data from the
Genome Reference Consortium.
Returned objects will always be restricted to assembled molecules only.
Currently implemented genome builds represent the four most common builds
for ChIP-Seq analysis
}
\examples{
defineSeqinfo("GRCh37", TRUE)
defineSeqinfo("GRCh37", FALSE, "MT")


}
