% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mergeByHMP.R
\name{mergeByHMP}
\alias{mergeByHMP}
\alias{mergeByHMP,GenomicRanges-method}
\alias{mergeByHMP,RangedSummarizedExperiment-method}
\title{Merge Sliding Windows using the Harmonic Mean P}
\usage{
mergeByHMP(x, ...)

\S4method{mergeByHMP}{GenomicRanges}(
  x,
  df = NULL,
  w = NULL,
  logfc = "logFC",
  pval = "P",
  cpm = "logCPM",
  inc_cols = NULL,
  p_adj_method = "fdr",
  merge_within = 1L,
  ignore_strand = TRUE,
  min_win = 1,
  keyval = c("min", "merged"),
  hm_pre = "hm",
  ...
)

\S4method{mergeByHMP}{RangedSummarizedExperiment}(
  x,
  df = NULL,
  w = NULL,
  logfc = "logFC",
  pval = "P",
  cpm = "logCPM",
  inc_cols = NULL,
  p_adj_method = "fdr",
  merge_within = 1L,
  ignore_strand = FALSE,
  hm_pre = "hm",
  ...
)
}
\arguments{
\item{x}{GenomicRanges object}

\item{...}{Not used}

\item{df}{data.frame with results of differential binding analysis performed
using a sliding window strategy. If not provided, the columns in the
\code{mcols()} element of \code{x} will be used}

\item{w}{vector of weights to applied when calculating harmonic mean p-values}

\item{logfc, pval, cpm}{Column names for the values holding window specific
estimates of change in binding (logfc), overall signal intensity (cpm) and
the significance from statistical testing (pval).}

\item{inc_cols}{(Optional) Character vector of any additional columns in
\code{df} to return. Values will correspond to the range in the \code{keyval_range}
column}

\item{p_adj_method}{One of \code{p.adjust.methods} or "fwer". If "fwer" is
specified the adjusted harmonic-mean p-value will be returned in a form
which strictly controls the experiment-wide FWER. Please see
vignette("harmonicmeanp") for more details}

\item{merge_within}{Merge any non-overlapping windows within this distance}

\item{ignore_strand}{Passed internally to \link[GenomicRanges]{reduce} and
\link[GenomicRanges]{findOverlaps}}

\item{min_win}{Only keep merged windows derived from at least this number}

\item{keyval}{Return the key-value range as the window associated with the
minimum p-value, or by merging the ranges from all windows with raw p-values
below the merged harmonic-mean p-value}

\item{hm_pre}{Prefix to add to the beginning of all HMP-derived columns}
}
\value{
A GenomicRanges object with merged ranges from the original object along with
summarised or representative values from the relevant columns. The range
corresponding to a representative values is also returned as described above
}
\description{
Merge overlapping windows using harmonic mean p-values from significance
testing
}
\details{
When using sliding windows to test for differential signal, overlapping
windows can be merged based on the significance of results.
\code{mergeByHMP()} merges overlapping windows using the asymptotically exact
harmonic mean p-value \link[harmonicmeanp]{p.hmp} from the individual,
window-level tests. This tests the Null Hypothesis that there is no
significance amongst the initial set of p-values, and returns a summarised
value which controls the FDR within a set of tests (Wilson, PNAS, 2019).
Multilevel testing across the set of results is currently implemented using
\code{p_adj_method = "fwer"}

Given that the harmonic mean p-value is calculated from the inverse p-values,
these are used to provide a \emph{weighted average} of expression and logFC values
in the returned object. Any weights provided in \code{w} are ignored for these
values as they are simple representative estimates.
The representative range returned in \code{keyval_range} corresponds to the window
with the lowest p-value.

The total number of windows is also returned in the final object, with the
summarised values n_up and n_down indicating the number of windows with raw
p-values below the calculated harmonic mean p-value, and with the
corresponding direction of change.

The column containing the harmonic mean p-values is returned as 'hmp'.
An additional column with adjusted hmp-values is returned with the suffix
'_*' added where the p-value adjustment method is added after the underscore.
}
\examples{
x <- GRanges(c("chr1:1-10", "chr1:6-15", "chr1:51-60"))
set.seed(1001)
df <- DataFrame(logFC = rnorm(3), logCPM = rnorm(3,8), p = rexp(3, 10))
mergeByHMP(x, df, pval = "p")
mcols(x) <- df
x
mergeByHMP(x, pval = "p", p_adj_method = "fwer")

}
