% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getGeneSetsForPlot.R
\name{getGeneSetsForPlot}
\alias{getGeneSetsForPlot}
\title{get gene sets for plot of \linkS4class{eSet} object.}
\usage{
getGeneSetsForPlot(
  entrezIdentifiers,
  species = "Human",
  geneSetSource = c("GOBP", "GOMF", "GOCC", "KEGG"),
  useDescription = TRUE,
  trace = TRUE
)
}
\arguments{
\item{entrezIdentifiers}{string with Entrez Gene identifiers of the genes of interest}

\item{species}{species to use, given to the \code{\link[MLP]{getGeneSets}} function}

\item{geneSetSource}{gene set source, either 'GOBP', 'GOMF', 'GOCC' or 'KEGG'.
Multiple choices are available}

\item{useDescription}{logical, if TRUE (by default) use the description to 
label the gene sets, otherwise use the original gene set identifiers
Function 'substr' is used.}

\item{trace}{logical, if TRUE (by default) 
a few extra information are printed during the process}
}
\value{
list with gene sets, each element is a gene set and 
contains the ENTREZ IDs of the genes contained in this set.
If \code{useDescription} is:
\itemize{
	\item{FALSE: }{pathways are labelled with identifiers (Gene Ontology IDs for GOBP, GOMF and GOCC, KEGG IDs for KEGG)}
 \item{TRUE: }{pathways are labelled with gene sets descriptions}
}
}
\description{
get and format gene sets to be used as \code{geneSets} for the functions:
\code{\link{esetSpectralMap}}, \code{\link{esetLda}}, or \code{\link{esetPlotWrapper}}
Use the \code{\link[MLP]{getGeneSets}} function to get the gene sets,
combine all databases, and format the gene sets name if required.
}
\examples{
# example dataset
library(ALL)
data(ALL)

# get gene annotation from probe IDs
library("hgu95av2.db")
probeIDs <- featureNames(ALL)
geneInfo <- select(hgu95av2.db, probeIDs,"ENTREZID", "PROBEID")

# get pathway annotation for the genes contained in the ALL dataset (can take a few minutes)
geneSets <- getGeneSetsForPlot(entrezIdentifiers = geneInfo$ENTREZID, species = "Human", 
	geneSetSource = 'GOBP',
	useDescription = FALSE, trace = TRUE)
head(geneSets) # returns a pathway list of genes

# gene sets labelled with gene sets description
geneSets <- getGeneSetsForPlot(entrezIdentifiers = geneInfo$ENTREZID, species = "Human", 
	geneSetSource = 'GOBP', useDescription = TRUE, trace = TRUE)
head(geneSets) # returns a pathway list of genes

# see also vignette for an example of the use of this function as input for the esetSpectralMap, esetLda or esetPlotWrapper functions
}
\seealso{
the function used internally: \code{\link[MLP]{getGeneSets}}
}
\author{
Laure Cougnaud
}
