% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_escheR.R
\name{make_escheR}
\alias{make_escheR}
\alias{make_escheR.SingleCellExperiment}
\alias{make_escheR.SpatialExperiment}
\alias{make_escheR.data.frame}
\title{Create a new spatial map for spatial transcriptomics data}
\usage{
make_escheR(object, spot_size = 2, ...)

\method{make_escheR}{SingleCellExperiment}(object, spot_size = 2, dimred = "PCA", ...)

\method{make_escheR}{SpatialExperiment}(object, spot_size = 2, dimred = NULL, y_reverse = TRUE, ...)

\method{make_escheR}{data.frame}(object, spot_size = 2, .x, .y, ...)
}
\arguments{
\item{object}{a data object that contains the spatial transcriptomics data.
Currently only working for spatial transcriptomics data as
\code{SpatialExperiment} objects.}

\item{spot_size}{A numeric(1) specifying the size of the spot in the ggplot.
Defaults to 2.}

\item{...}{Reserved for future arguments.}

\item{dimred}{String or integer scalar specifying the existing dimensionality reduction results to use.}

\item{y_reverse}{(logical) Whether to reverse y coordinates, which is often
required for 10x Genomics Visium data. Default = TRUE.}

\item{.x}{the X-coordinate}

\item{.y}{the Y-coordinate}
}
\value{
an ggplot object that contains the spatial transcriptomics data.
}
\description{
\code{make_escheR()} is a generic function to initialize a ggplot object
that contains a spatial map. Because the ggplot object saves the input
spatial transcriptomics data, the transcriptomics data will be used in
the following layering process to add more aesthestic components in the
plot following the grammar of graphics and ggplot2 syntax.
}
\examples{
library(STexampleData)
# SpatialExperiment Object
spe <- Visium_humanDLPFC()
make_escheR(spe)

# SingleCellExperiment Object
sce <- SingleCellExperiment(counts(spe))
reducedDims(sce) <- list(
   # Example embedding
    EG = matrix(seq.int(1, ncol(spe)*2), ncol = 2)
    )
make_escheR(sce, dimred = "EG")

# data.frame Object
x <- spatialCoords(spe)[,1]
y <- spatialCoords(spe)[,2]
df <- colData(spe) |> data.frame()
make_escheR(object = df, .x = x , .y = y)
}
\references{
Guo B, Huuki-Myers LA, Grant-Peters M, Collado-Torres L, Hicks SC (2023).
escheR: Unified multi-dimensional visualizations with Gestalt principles.
\emph{Bioinformatics Advances}, Volume 3, Issue 1, vbad179, doi:10.1093/bioadv/vbad179
}
