% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SamToBed.R
\name{SamToBed}
\alias{SamToBed}
\alias{atacSamToBed,ATACProc-method}
\alias{atacSamToBed}
\alias{samToBed}
\title{Convert SAM file to BED file}
\usage{
atacSamToBed(
  atacProc,
  reportOutput = NULL,
  merge = c("auto", "yes", "no"),
  posOffset = +4,
  negOffset = -5,
  chrFilterList = "chrM",
  samInput = NULL,
  bedOutput = NULL,
  sortBed = TRUE,
  minFragLen = 0,
  maxFragLen = 100,
  saveExtLen = FALSE,
  uniqueBed = TRUE,
  ...
)

\S4method{atacSamToBed}{ATACProc}(
  atacProc,
  reportOutput = NULL,
  merge = c("auto", "yes", "no"),
  posOffset = +4,
  negOffset = -5,
  chrFilterList = "chrM",
  samInput = NULL,
  bedOutput = NULL,
  sortBed = TRUE,
  minFragLen = 0,
  maxFragLen = 100,
  saveExtLen = FALSE,
  uniqueBed = TRUE,
  ...
)

samToBed(
  samInput,
  reportOutput = NULL,
  merge = c("auto", "yes", "no"),
  posOffset = +4,
  negOffset = -5,
  chrFilterList = "chrM",
  bedOutput = NULL,
  sortBed = TRUE,
  minFragLen = 0,
  maxFragLen = 100,
  saveExtLen = FALSE,
  uniqueBed = TRUE,
  ...
)
}
\arguments{
\item{atacProc}{\code{\link{ATACProc-class}} object scalar.
It has to be the return value of upstream process:
\code{\link{atacBowtie2Mapping}}
\code{\link{bowtie2Mapping}}}

\item{reportOutput}{\code{Character} scalar
report file path}

\item{merge}{\code{Logical} scalar
Merge paired end reads.}

\item{posOffset}{\code{Integer} scalar
The offset that positive strand reads will shift.}

\item{negOffset}{\code{Integer} scalar
The offset that negative strand reads will shift.}

\item{chrFilterList}{\code{Character} vector
The chromatin(or regex of chromatin) will be discard}

\item{samInput}{\code{Character} scalar.
SAM file input path.}

\item{bedOutput}{\code{Character} scalar.
Bed file output path.}

\item{sortBed}{\code{Logical} scalar
Sort bed file in the order of chromatin, start, end}

\item{minFragLen}{\code{Integer} scalar
The minimum fragment size will be retained.}

\item{maxFragLen}{\code{Integer} scalar
The maximum fragment size will be retained.}

\item{saveExtLen}{\code{Logical} scaler
Save the fragment that are not in the range of minFragLen and maxFragLen}

\item{uniqueBed}{\code{Logical} scalar
Remove duplicates reads in bed if TRUE. default: FALSE}

\item{...}{Additional arguments, currently unused.}
}
\value{
An invisible \code{\link{ATACProc-class}} object scalar for downstream analysis.
}
\description{
This function is used to convert SAM file to BED file and
merge interleave paired end reads,
shift reads,
filter reads according to chromosome,
filter reads according to fragment size,
sort,
remove duplicates reads before generating BED file.
}
\details{
The parameter related to input and output file path
will be automatically
obtained from \code{\link{ATACProc-class}} object(\code{atacProc}) or
generated based on known parameters
if their values are default(e.g. \code{NULL}).
Otherwise, the generated values will be overwrited.
If you want to use this function independently,
you can use \code{samToBed} instead.
}
\examples{
library(R.utils)
library(magrittr)
td <- tempdir()
setTmpDir(td)

sambzfile <- system.file(package="esATAC", "extdata", "Example.sam.bz2")
samfile <- file.path(td,"Example.sam")
bunzip2(sambzfile,destname=samfile,overwrite=TRUE,remove=FALSE)
samToBed(samInput = samfile)
}
\seealso{
\code{\link{atacBowtie2Mapping}}
\code{\link{bowtie2Mapping}}
\code{\link{atacFragLenDistr}}
\code{\link{atacExtractCutSite}}
\code{\link{atacPeakCalling}}
\code{\link{atacBedUtils}}
\code{\link{atacTSSQC}}
\code{\link{atacBedToBigWig}}
}
\author{
Zheng Wei
}
