% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RemoveAdapter.R
\name{RemoveAdapter}
\alias{RemoveAdapter}
\alias{atacRemoveAdapter,ATACProc-method}
\alias{atacRemoveAdapter}
\alias{removeAdapter}
\title{Use AdapterRemoval to remove adapters}
\usage{
atacRemoveAdapter(
  atacProc,
  adapter1 = NULL,
  adapter2 = NULL,
  fastqOutput1 = NULL,
  reportPrefix = NULL,
  fastqOutput2 = NULL,
  fastqInput1 = NULL,
  fastqInput2 = NULL,
  interleave = FALSE,
  threads = getThreads(),
  paramList = NULL,
  findParamList = NULL,
  ...
)

\S4method{atacRemoveAdapter}{ATACProc}(
  atacProc,
  adapter1 = NULL,
  adapter2 = NULL,
  fastqOutput1 = NULL,
  reportPrefix = NULL,
  fastqOutput2 = NULL,
  fastqInput1 = NULL,
  fastqInput2 = NULL,
  interleave = FALSE,
  threads = getThreads(),
  paramList = NULL,
  findParamList = NULL,
  ...
)

removeAdapter(
  fastqInput1,
  fastqInput2,
  adapter1,
  adapter2,
  fastqOutput1 = NULL,
  reportPrefix = NULL,
  fastqOutput2 = NULL,
  interleave = FALSE,
  threads = getThreads(),
  paramList = NULL,
  findParamList = NULL,
  ...
)
}
\arguments{
\item{atacProc}{\code{\link{ATACProc-class}} object scalar.
It has to be the return value of upstream process:
\code{\link{atacRenamer}}
\code{\link{renamer}}
\code{\link{atacUnzipAndMerge}}
\code{\link{unzipAndMerge}}}

\item{adapter1}{\code{Character}. It is an adapter sequence for file1.
For single end data, it is requied.}

\item{adapter2}{\code{Character}. It is an adapter sequence for file2.}

\item{fastqOutput1}{\code{Character}. The trimmed mate1 reads output file
path for fastqInput2. Defualt:
basename.pair1.truncated (paired-end),
basename.truncated (single-end), or
basename.paired.truncated (interleaved)}

\item{reportPrefix}{\code{Character}. The prefix of report files path.
Default: generate from known parameters}

\item{fastqOutput2}{\code{Character}. The trimmed mate2 reads output file
path for fastqInput2. Default:
BASENAME.pair2.truncated (only used in PE mode, but not if
--interleaved-output is enabled)}

\item{fastqInput1}{\code{Character} vector. For single-end sequencing,
it contains sequence file paths.
For paired-end sequencing, it can be file paths with #1 mates paired
with file paths in fastqInput2
And it can also be interleaved file paths when argument
interleaved=\code{TRUE}}

\item{fastqInput2}{\code{Character} vector. It contains file paths with #2
mates paired with file paths in fastqInput1
For single-end sequencing files and interleaved paired-end sequencing
files(argument interleaved=\code{TRUE}),
it must be \code{NULL}.}

\item{interleave}{\code{Logical}. Set \code{TRUE} when files are
interleaved paired-end sequencing data.}

\item{threads}{\code{Numeric}. The max threads allowed to be used by this step.
Default: getThreads()}

\item{paramList}{Additional arguments to be passed on to the binaries
for removing adapter. See below for details.}

\item{findParamList}{Additional arguments to be passed on to the binaries
for identifying adapter. See below for details.}

\item{...}{Additional arguments, currently unused.}
}
\value{
An invisible \code{\link{ATACProc-class}} object scalar for downstream analysis.
}
\description{
Use AdapterRemoval to remove adapters
}
\details{
The parameter related to input and output file path
will be automatically
obtained from \code{\link{ATACProc-class}} object or
generated based on known parameters
if their values are default(e.g. \code{NULL}).
Otherwise, the generated values will be overwrited.
If you want to use this function independently,
you can use \code{removeAdapter} instead.
You can put all aditional
arguments in one \code{Character}(e.g. "--threads 8") with white space
splited just like command line,
or put them in \code{Character} vector(e.g. c("--threads","8")).
Note that some arguments(
"--file1","--file2","--adapter1","--adapter2","--output1","--output2",
"--basename","--interleaved","thread") to the
paramList and findParamList are invalid if they are already handled as explicit
function arguments. See the output of
\code{adapterremoval_usage()} for details about available parameters.
}
\examples{
library(magrittr)
td <- tempdir()
setTmpDir(td)

# Identify adapters
prefix<-system.file(package="esATAC", "extdata", "uzmg")
(reads_1 <-file.path(prefix,"m1",dir(file.path(prefix,"m1"))))
(reads_2 <-file.path(prefix,"m2",dir(file.path(prefix,"m2"))))

reads_merged_1 <- file.path(td,"reads1.fastq")
reads_merged_2 <- file.path(td,"reads2.fastq")
atacproc <-
atacUnzipAndMerge(fastqInput1 = reads_1,fastqInput2 = reads_2) \%>\%
atacRenamer \%>\% atacFindAdapter \%>\% atacRemoveAdapter

dir(td)
}
\seealso{
\code{\link{atacRenamer}}
\code{\link{renamer}}
\code{\link{atacUnzipAndMerge}}
\code{\link{unzipAndMerge}}
\code{\link{atacBowtie2Mapping}}
}
\author{
Zheng Wei
}
