% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RPeakAnno.R
\name{RPeakAnno}
\alias{RPeakAnno}
\alias{atacPeakAnno,ATACProc-method}
\alias{atacPeakAnno}
\alias{peakanno}
\title{Annotate ATAC-seq Peak}
\usage{
atacPeakAnno(
  atacProc,
  peakInput = NULL,
  tssRegion = c(-1000, 1000),
  TxDb = NULL,
  level = "transcript",
  genomicAnnotationPriority = c("Promoter", "5UTR", "3UTR", "Exon", "Intron",
    "Downstream", "Intergenic"),
  annoDb = NULL,
  addFlankGeneInfo = FALSE,
  flankDistance = 5000,
  sameStrand = FALSE,
  ignoreOverlap = FALSE,
  ignoreUpstream = FALSE,
  ignoreDownstream = FALSE,
  overlap = "TSS",
  annoOutput = NULL,
  ...
)

\S4method{atacPeakAnno}{ATACProc}(
  atacProc,
  peakInput = NULL,
  tssRegion = c(-1000, 1000),
  TxDb = NULL,
  level = "transcript",
  genomicAnnotationPriority = c("Promoter", "5UTR", "3UTR", "Exon", "Intron",
    "Downstream", "Intergenic"),
  annoDb = NULL,
  addFlankGeneInfo = FALSE,
  flankDistance = 5000,
  sameStrand = FALSE,
  ignoreOverlap = FALSE,
  ignoreUpstream = FALSE,
  ignoreDownstream = FALSE,
  overlap = "TSS",
  annoOutput = NULL,
  ...
)

peakanno(
  peakInput,
  tssRegion = c(-1000, 1000),
  TxDb = NULL,
  level = "transcript",
  genomicAnnotationPriority = c("Promoter", "5UTR", "3UTR", "Exon", "Intron",
    "Downstream", "Intergenic"),
  annoDb = NULL,
  addFlankGeneInfo = FALSE,
  flankDistance = 5000,
  sameStrand = FALSE,
  ignoreOverlap = FALSE,
  ignoreUpstream = FALSE,
  ignoreDownstream = FALSE,
  overlap = "TSS",
  annoOutput = NULL,
  ...
)
}
\arguments{
\item{atacProc}{\code{\link{ATACProc-class}} object scalar.
It has to be the return value of upstream process:
\code{\link{atacPeakCalling}}.}

\item{peakInput}{\code{Character} scalar.
Input peak file path. UCSC bed file is recommented. Other file should be
able to import as \code{\link{GRanges}} objects through
 \code{import} in package rtracklayer.}

\item{tssRegion}{Region range of TSS, default:c(-1000, 1000).}

\item{TxDb}{TxDb object, annotation database.}

\item{level}{"transcript" or "gene".}

\item{genomicAnnotationPriority}{genomic annotation priority.}

\item{annoDb}{Gene annotation database.}

\item{addFlankGeneInfo}{logical, add flanking gene information from
the peaks.}

\item{flankDistance}{distance of flanking sequence.}

\item{sameStrand}{logical, whether find nearest/overlap gene in the
same strand.}

\item{ignoreOverlap}{logical, whether ignore overlap of TSS with peak.}

\item{ignoreUpstream}{logical, if True only annotate gene at the 3'
of the peak.}

\item{ignoreDownstream}{logical, if True only annotate gene at the
5' of the peak.}

\item{overlap}{one of 'TSS' or 'all', if overlap="all", then gene overlap
with peak will be reported as nearest gene, no matter the overlap is at TSS
region or not.}

\item{annoOutput}{\code{Character} scalar.
the output file path.}

\item{...}{Additional arguments, currently unused.}
}
\value{
An invisible \code{\link{ATACProc-class}} object scalar for
downstream analysis.
}
\description{
This function annotates ATAC-seq peak by a given annotation database.
For more information, please see \code{\link{annotatePeak}}.
}
\examples{


library(R.utils)
library(TxDb.Hsapiens.UCSC.hg19.knownGene)
p1bz <- system.file("extdata", "Example_peak1.bed.bz2", package="esATAC")
peak1_path <- as.vector(bunzip2(filename = p1bz,
destname = file.path(getwd(), "Example_peak1.bed"),
ext="bz2", FUN=bzfile, overwrite=TRUE, remove = FALSE))
#peakanno(peakInput = peak1_path, TxDb = TxDb.Hsapiens.UCSC.hg19.knownGene,
#annoDb = 'org.Hs.eg.db')

}
\references{
Guangchuang Yu, Li-Gen Wang, Qing-Yu He. ChIPseeker: an
R/Bioconductor package for ChIP peak annotation, comparison and
visualization. Bioinformatics 2015, 31(14):2382-2383
}
\seealso{
\code{\link{atacPeakCalling}}
\code{\link{atacGOAnalysis}}
}
\author{
Wei Zhang
}
