% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RMotifScan.R
\name{RMotifScan}
\alias{RMotifScan}
\alias{atacMotifScan,ATACProc-method}
\alias{atacMotifScan}
\alias{motifscan}
\title{Search Motif Position in Given Regions}
\usage{
atacMotifScan(
  atacProc,
  peak = NULL,
  genome = NULL,
  motifs = NULL,
  p.cutoff = 1e-06,
  scanO.dir = NULL,
  prefix = NULL,
  ...
)

\S4method{atacMotifScan}{ATACProc}(
  atacProc,
  peak = NULL,
  genome = NULL,
  motifs = NULL,
  p.cutoff = 1e-06,
  scanO.dir = NULL,
  prefix = NULL,
  ...
)

motifscan(
  peak = NULL,
  genome = NULL,
  motifs = NULL,
  p.cutoff = 1e-06,
  scanO.dir = NULL,
  prefix = NULL,
  ...
)
}
\arguments{
\item{atacProc}{\code{\link{ATACProc-class}} object scalar.
It has to be the return value of upstream process:
\code{\link{atacPeakCalling}}.}

\item{peak}{\code{Character} scalar.
Input region path. UCSC bed file is recommented. Other file should be able
to import as \code{\link{GRanges}} objects through
\code{import} in package rtracklayer.}

\item{genome}{BSgenome object, Default: from \code{\link{getRefRc}}.}

\item{motifs}{either\code{\link{PFMatrix}}, \code{\link{PFMatrixList}},
\code{\link{PWMatrix}}, \code{\link{PWMatrixList}}.}

\item{p.cutoff}{p-value cutoff for returning motifs.}

\item{scanO.dir}{\code{Character} scalar.
the output file directory. This function will use the name in motifs as
the file name to save the motif position information in separate files.}

\item{prefix}{prefix for Output file.}

\item{...}{Additional arguments, currently unused.}
}
\value{
An invisible \code{\link{ATACProc-class}} object scalar for
downstream analysis.
}
\description{
Search motif position in genome according thr given motif and peak information.
}
\details{
This function scan motif position in a given genome regions.
}
\examples{

\dontrun{
library(R.utils)
library(BSgenome.Hsapiens.UCSC.hg19)
peak.path <- system.file("extdata", "Example_peak1.bed.bz2", package="esATAC")
peak.path <- as.vector(bunzip2(filename = peak.path, destname = file.path(getwd(), "Example_peak1.bed"), ext="bz2", FUN=bzfile, overwrite=TRUE , remove = FALSE))

motif <- readRDS(system.file("extdata", "MotifPFM.rds", package="esATAC"))

motifscan(peak = peak.path, genome = BSgenome.Hsapiens.UCSC.hg19, motifs = motif)
}


}
\seealso{
\code{\link{atacPeakCalling}}
\code{\link{atacCutSiteCount}}
}
\author{
Wei Zhang
}
