% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PeakQC.R
\name{PeakQC}
\alias{PeakQC}
\alias{atacPeakQC,ATACProc-method}
\alias{atacPeakQC}
\alias{peakQC}
\title{Quality control for peak overlap}
\usage{
atacPeakQC(
  atacProc,
  bsgenome = NULL,
  reportOutput = NULL,
  qcbedInput = c("DHS", "blacklist", "path/to/bed"),
  bedInput = NULL,
  newStepType = "PeakQC",
  ...
)

\S4method{atacPeakQC}{ATACProc}(
  atacProc,
  bsgenome = NULL,
  reportOutput = NULL,
  qcbedInput = c("DHS", "blacklist", "path/to/bed"),
  bedInput = NULL,
  newStepType = "PeakQC",
  ...
)

peakQC(
  bedInput,
  bsgenome = NULL,
  reportOutput = NULL,
  qcbedInput = c("DHS", "blacklist", "path/to/bed"),
  newStepType = "PeakQC",
  ...
)
}
\arguments{
\item{atacProc}{\code{\link{ATACProc-class}} object scalar.
It has to be the return value of upstream process:
\code{\link{atacSamToBed}},
\code{\link{atacBedUtils}}.}

\item{bsgenome}{\code{BSGenome} object scalar.
BSGenome object for specific species.}

\item{reportOutput}{\code{Character} scalar.
The report file path.}

\item{qcbedInput}{\code{Character} scalar.
It can be "DHS","blacklist" or
Other quality control BED file input path.}

\item{bedInput}{\code{Character} scalar.
BED file input path for quality control.}

\item{newStepType}{\code{Character} scalar.
New step type name for different default parameters.}

\item{...}{Additional arguments, currently unused.}
}
\value{
An invisible \code{\link{ATACProc-class}} object scalar for downstream analysis.
}
\description{
These functions are used to 
calculate the overlap ratio in specific quality control rigion.
Blacklist and DHS region are provided. 
You can also set your own BED file as quality control rigion.
}
\details{
The parameter related to input and output file path
will be automatically
obtained from \code{\link{ATACProc-class}} object or
generated based on known parameters
if their values are default(e.g. \code{NULL}).
Otherwise, the generated values will be overwrited.
If you want to use this function independently,
you can use \code{peakQC} instead.
}
\examples{
library(R.utils)
library(magrittr)
td <- tempdir()
setTmpDir(td)

bedbzfile <- system.file(package="esATAC", "extdata", "chr20.50000.bed.bz2")
bedfile <- file.path(td,"chr20.50000.bed")
bunzip2(bedbzfile,destname=bedfile,overwrite=TRUE,remove=FALSE)
blacklistfile <- system.file(package="esATAC", "extdata", "hg19.blacklist.bed")
library(BSgenome.Hsapiens.UCSC.hg19)
bedUtils(bedInput = bedfile,maxFragLen = 100, chrFilterList = NULL) \%>\%
atacPeakCalling \%>\% atacPeakQC(qcbedInput = blacklistfile, bsgenome = BSgenome.Hsapiens.UCSC.hg19)
dir(td)
}
\seealso{
\code{\link{atacSamToBed}}
\code{\link{atacBedUtils}}
}
\author{
Zheng Wei
}
