% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PeakCallingFseq.R
\name{PeakCallingFseq}
\alias{PeakCallingFseq}
\alias{atacPeakCalling,ATACProc-method}
\alias{atacPeakCalling}
\alias{peakCalling}
\title{Use F-seq to call peak}
\usage{
atacPeakCalling(
  atacProc,
  bedInput = NULL,
  background = NULL,
  genomicReadsCount = NULL,
  fragmentSize = 0,
  featureLength = NULL,
  bedOutput = NULL,
  ploidyDir = NULL,
  fileformat = c("bed", "wig", "npf"),
  wiggleTrackStep = NULL,
  threshold = NULL,
  verbose = TRUE,
  wgThresholdSet = NULL,
  ...
)

\S4method{atacPeakCalling}{ATACProc}(
  atacProc,
  bedInput = NULL,
  background = NULL,
  genomicReadsCount = NULL,
  fragmentSize = 0,
  featureLength = NULL,
  bedOutput = NULL,
  ploidyDir = NULL,
  fileformat = c("bed", "wig", "npf"),
  wiggleTrackStep = NULL,
  threshold = NULL,
  verbose = TRUE,
  wgThresholdSet = NULL,
  ...
)

peakCalling(
  bedInput,
  background = NULL,
  genomicReadsCount = NULL,
  fragmentSize = 0,
  featureLength = NULL,
  bedOutput = NULL,
  ploidyDir = NULL,
  fileformat = c("bed", "wig", "npf"),
  wiggleTrackStep = NULL,
  threshold = NULL,
  verbose = TRUE,
  wgThresholdSet = NULL,
  ...
)
}
\arguments{
\item{atacProc}{\code{\link{ATACProc-class}} object scalar.
It has to be the return value of upstream process:
\code{\link{atacSamToBed}},
\code{\link{atacBedUtils}}.}

\item{bedInput}{\code{Character} scalar.
BED file input path.}

\item{background}{\code{Character} scalar.
background directory default: NULL (none)}

\item{genomicReadsCount}{\code{Integer} scalar.
genomic count of sequence reads. default: NULL (calculated)}

\item{fragmentSize}{\code{Integer} scalar.
fragment size. set NULL to estimat from data. default:0}

\item{featureLength}{\code{Character} scalar.
feature length default: NULL (600)}

\item{bedOutput}{\code{Character} scalar.
the output bed file path}

\item{ploidyDir}{\code{Character} scalar.
ploidy/input directory. default: NULL}

\item{fileformat}{\code{Character} scalar.
File format of result. default: bed}

\item{wiggleTrackStep}{\code{Integer} scalar.
wiggle track step default: NULL (1)}

\item{threshold}{\code{Numeric} scalar.
threshold (standard deviations) default: NULL (4.0)}

\item{verbose}{\code{Logical} scalar.
verbose output if TRUE.}

\item{wgThresholdSet}{\code{Character} scalar.
wg threshold set default: NULL (calculated)}

\item{...}{Additional arguments, currently unused.}
}
\value{
An invisible \code{\link{ATACProc-class}} object scalar for downstream analysis.
}
\description{
Use F-seq to call peak
}
\details{
The parameter related to input and output file path
will be automatically
obtained from \code{\link{ATACProc-class}} object(\code{atacProc}) or
generated based on known parameters
if their values are default(e.g. \code{NULL}).
Otherwise, the generated values will be overwrited.
If you want to use this function independently,
you can use \code{peakCalling} instead.
}
\examples{
library(R.utils)
library(magrittr)
td <- tempdir()
setTmpDir(td)

bedbzfile <- system.file(package="esATAC", "extdata", "chr20.50000.bed.bz2")
bedfile <- file.path(td,"chr20.50000.bed")
bunzip2(bedbzfile,destname=bedfile,overwrite=TRUE,remove=FALSE)

bedUtils(bedInput = bedfile,maxFragLen = 100, chrFilterList = NULL) \%>\%
atacPeakCalling

dir(td)
}
\seealso{
\code{\link{atacSamToBed}}
\code{\link{samToBed}}
\code{\link{atacBedUtils}}
\code{\link{bedUtils}}
}
\author{
Zheng Wei
}
